using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class TestDataSet : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
      DataSet ds = new DataSet();
      ds.Tables.Add( MakeCustomerData() );
      ds.Tables.Add( MakeProductData() );
      ds.Tables[1].TableName = "Products";
 

      grdCustomer.DataSource = ds.Tables[0].DefaultView;
      grdCustomer.DataBind();

      grdProducts.DataSource = ds.Tables["Products"].DefaultView;
      grdProducts.DataBind();
    }

    /// <summary>
    /// Creates and returns a populated DataTable
    /// </summary>
    private DataTable MakeCustomerData()
    {
       DataTable table = new DataTable();

       DataColumn idCol = new DataColumn();
       idCol.ColumnName = "Id";
       idCol.DataType = typeof(Int32);
       idCol.AllowDBNull = false;
       idCol.Unique = true;
       idCol.AutoIncrement = true;

       DataColumn firstNameCol = new DataColumn("FirstName", typeof(string));
       DataColumn lastNameCol = new DataColumn("LastName", typeof(string));
       DataColumn phoneCol = new DataColumn("Phone", typeof(string));

       table.Columns.Add(idCol);
       table.Columns.Add(firstNameCol);
       table.Columns.Add(lastNameCol);
       table.Columns.Add(phoneCol);

       DataRow r1 = table.NewRow();
       r1[1] = "Thomas";
       r1[2] = "Hobbes";
       r1[3] = "123-4567";
       table.Rows.Add(r1);

       DataRow r2 = table.NewRow();
       r2["FirstName"] = "David";
       r2["LastName"] = "Hume";
       r2["Phone"] = "564-7823";
       table.Rows.Add(r2);

       DataRow r3 = table.NewRow();
       r3["FirstName"] = "Martin";
       r3["LastName"] = "Heidegger";
       r3["Phone"] = "253-6383";
       table.Rows.Add(r3);

       DataRow r4 = table.NewRow();
       r4["FirstName"] = "Jean-Jacques";
       r4["LastName"] = "Rosseau";
       r4["Phone"] = "456-1267";
       table.Rows.Add(r4);

       return table;
    }


    /// <summary>
    /// Creates and returns a populated DataTable
    /// </summary>
    private DataTable MakeProductData()
    {
       DataTable table = new DataTable();

       DataColumn idCol = new DataColumn();
       idCol.ColumnName = "Id";
       idCol.DataType = typeof(Int32);
       idCol.AllowDBNull = false;
       idCol.Unique = true;
       idCol.AutoIncrement = true;

       DataColumn nameCol = new DataColumn("Name", typeof(string));
       DataColumn priceCol = new DataColumn("Price", typeof(double));

       table.Columns.Add(idCol);
       table.Columns.Add(nameCol);
       table.Columns.Add(priceCol);

       DataRow r1 = table.NewRow();
       r1[1] = "Book";
       r1[2] = 49.99;
       table.Rows.Add(r1);

       DataRow r2 = table.NewRow();
       r2[1] = "Apple";
       r2[2] = 0.99;
       table.Rows.Add(r2);

       return table;
    }
}
