using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class IterationExamples : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
       // create sample customer objects
       Customer c1 = new Customer("334", "Thomas", "Hobbes", "123-4567");
       Customer c2 = new Customer("123", "Jean-Jacques", "Rosseau","456-1267");
       Customer c3 = new Customer("085", "David", "Hume", "564-7823");
       Customer c4 = new Customer("254", "Martin", "Heidegger", "253-6383");

       // create and populate collection
       ArrayList myList = new ArrayList();
       myList.Add(c1);
       myList.Add(c2);
       myList.Add(c3);
       myList.Add(c4);

       // first iteration
       labMsg.Text = "<h2>First Iteration Output  (ArrayList)</h2>";
       for (int i = 0; i < myList.Count; i++)
       {
          Customer c = (Customer)myList[i];
          labMsg.Text += c.FirstName + "<br/>";
       }

       // second iteration
       labMsg.Text += "<h2>Second Iteration Output (ArrayList)</h2>";
       foreach (Customer c in myList)
       {
          labMsg.Text += c.FirstName + "<br/>";
       }

       // third iteration
       labMsg.Text += "<h2>Third Iteration Output (ArrayList)</h2>";
      IEnumerator ie = myList.GetEnumerator();
      while (ie.MoveNext())
      {
       Customer c = (Customer)ie.Current;
       labMsg.Text += c.FirstName + "<br/>";
      }

      Hashtable myTable = new Hashtable();
      myTable.Add(c1.Id, c1);
      myTable.Add(c2.Id, c2);
      myTable.Add(c3.Id, c3);
      myTable.Add(c4.Id, c4);

      // fourth iteration
      labMsg.Text += "<h2>Fourth Iteration Output (Hashtable)</h2>";
      foreach (DictionaryEntry de in myTable)
      {
         Customer c = (Customer)de.Value;
         labMsg.Text += c.FirstName + "<br/>";
      }

      // fifth iteration
      labMsg.Text += "<h2>Fifth Iteration Output (Hashtable)</h2>";
      foreach (Customer c in myTable.Values)
      {
         labMsg.Text += c.FirstName + "<br/>";
      }
    }
}
