using System;

/// <summary>
/// Encapsulates the data for a single product
/// </summary>
public class Product: AbstractEntity 
{
   // data members
   private string _name;
   private double _price;

   public Product(string id, string name, double price) : base(id)
	{
      _name = name;
      _price = price;
	}
   public string Name
   {
      get { return _name; }
      set { _name = value; }
   }
   public double Price
   {
      get { return _price; }
      set { _price = value; }
   }

   public override string ToString()
   {
      return Id + "," + Name + "," + Price;
   }

   /// <summary>
   /// Determines if this object's state is valid
   /// </summary>
   public override bool IsValid
   {
      get {
         if (Id.Length > 0 && Name.Length > 0)
            return true;
         else
            return false;
      }
   }
}
