using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;


/// <summary>
/// Oglna kolekcja dla encji biznesowych naszej aplikacji
/// </summary>
public class EntityCollection<T> : Collection<T> where T : AbstractEntity
{   

   /// <summary>
   /// Wyszukiwanie klienta o podanej wartoci Id
   /// </summary>
   public T FindById(string id)
   {
      foreach (T entity in this.Items)
      {
         if (entity.Id == id)
            return entity;
      }
      return null;
   }

   /// <summary>
   /// Sprawdzenie, czy kolekcja jest prawidowa. Jest to realizowane przez weryfikacj
   /// poprawnoci kadego elementu kolekcji.
   /// </summary>
   public bool IsValid()
   {
      bool valid = true;
      foreach (T entity in this.Items)
      {
         if (!entity.IsValid)
            valid = false;
      }
      return valid;
   }



}
