using System;

/// <summary>
/// Definiuje bazowy interfejs dla dowolnej encji
/// </summary>
public abstract class AbstractEntity
{
   // dane skadowe
   private string _id;

	public AbstractEntity(string id)
	{
      _id = id;
	}

   /// <summary>
   /// Kada encja musi mie swj identyfikator
   /// </summary>
   public string Id
   {
      get { return _id; }
      set { _id = value; }
   }

   /// <summary>
   /// Kada encja bdzie odpowiedzialna za sprawdzenie
   /// poprawnoci swojego stanu
   /// </summary>
   public abstract bool IsValid
   {
      get;
   }
}
