using System;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class TreeEventHandling : System.Web.UI.Page
{
   protected void Page_Load(object sender, EventArgs e)
   {
      if (!IsPostBack)
      {
         // wypenianie drzewa danymi
         FillTree();

         // zaczynamy od wszystkich wzw zwinitych
         treeMain.CollapseAll();
      }
   }

   /// <summary>
   /// Metoda pomocnicza do wypeniania drzewa danymi
   /// </summary>
   private void FillTree()
   {
      // pobranie wszystkich grup i ich przegldanie
      string[] groups = ProductCatalog.GetGroups();
      foreach (string grp in groups)
      {
         // tworzenie wza dla grupy
         TreeNode groupNode = new TreeNode(grp);
         // dla kadej grupy, pobranie podnaglwkw i przetwarzanie ich
         string[] subheadings =
            ProductCatalog.GetSubHeadingsByGroup(grp);
         foreach (string sub in subheadings)
         {
            // tworzenie wza dla podnagwka
            TreeNode subheadingNode = new TreeNode(sub);

            // dla kadego podnagwka, pobranie produktwi ich przetworzenie
            Product[] products =
                ProductCatalog.GetProductObjectsBySubHeading(sub);
            foreach (Product prod in products)
            {
               // utworzenie nowego wza produktu w drzewie
               TreeNode productNode = new TreeNode(prod.Name);

               // ustawienie waciwoci value wza na id produktu
               productNode.Value = prod.Id.ToString();

               // dodanie wza produktu do jego wza rodzica
               subheadingNode.ChildNodes.Add(productNode);
            }
            // dodanie wza podnagwka do jego wza rodzica
            groupNode.ChildNodes.Add(subheadingNode);
         }
         // dodanie wza grupy do jego wza rodzica
         treeMain.Nodes.Add(groupNode);
      }
   }

   /// <summary>
   /// Obsuguje zdarzenie wyboru wza drzewa
   /// </summary>
   protected void treeMain_SelectedNodeChanged(object sender, EventArgs e)
   {
      // pobranie zaznaczonego wza drzewa
      TreeNode node = treeMain.SelectedNode;

      // przetwarzanie tylko wzw lici
      if (node.ChildNodes.Count == 0)
      {
         // pobieranie identyfikatora produktu umieszczonego w wle
         int id = Convert.ToInt32(node.Value);

         // pobranie produktu na podstawie identyfikatora
         Product prod = ProductCatalog.GetProductById(id);
         
         // jeeli jest to prawidowy identyfikator, wywietlenie szczegw
         if (prod != null)
         {
            txtId.Text = prod.Id.ToString();
            txtIsbn.Text = prod.Isbn;
            txtName.Text = prod.Name;
            txtPrice.Text = String.Format("{0:c}", prod.Price);
         }
      }
   }

   /// <summary>
   /// Obsuga zdarzenia kliknicia przycisku zakupu
   /// </summary>
   protected void btnPurchase_Click(object sender, EventArgs e)
   {
      // obsuga braku zaznaczonych produktw
      if (treeMain.CheckedNodes.Count <= 0)
         labChoose.Text = "Nie zaznaczye adnego produktu do kupienia";
      else
      {
         labChoose.Text = "Zostay wybrane nastpujce produkty:";
         double total = 0.0;
         bulSelected.Items.Clear();

         // przegldanie zaznaczonych wzw
         foreach (TreeNode node in treeMain.CheckedNodes)
         {
            // pobieranie informacji o produkcie w wle
            int id = Convert.ToInt32(node.Value);
            Product prod = ProductCatalog.GetProductById(id);

            // jeeli jest to prawidowy produkt, dodanie go do listy i podsumowania
            if (prod != null)
            {               
               string s = prod.Name;
               s += "(" + String.Format("{0:c}", prod.Price) + ")";
               ListItem item = new ListItem(s);
               bulSelected.Items.Add(item);
               total += prod.Price;
            }
         }
         labTotal.Text = "Cakowita cena zakupu: ";
         labTotal.Text += String.Format("{0:c}", total);
      }
   }
}
