using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

/// <summary>
/// Represents a service object for the product catalog
/// </summary>
public static class ProductCatalog
{
   // Here the data is hard coded but real example would extract from database as needed
   private static Product[] _products = { 
      new Product(5, "Core Java","0131118269", 49.99), 
      new Product(6, "Core C# and .NET","0131472275", 49.99),  
      new Product(8, "Framework Design Guidelines", "0321246756", 59.99), 
      new Product(9, ".NET Web Services","0321113594", 39.99),
      new Product(11,"GDI Revealed", "9887129283", 54.65),
      new Product(12,"HTML for the Web", "0321130073", 21.99),
      new Product(15, "Zen of CSS Design", "0321303474", 39.99),
      new Product(16, "Core JavaServer Faces", "0131463055", 49.99), 
   
   };


   private static string[] _groups = { "Kategorie", "Serie" };

   private static string[] _subheadings1 = { "Grafika", "Internet", };
   private static string[] _subheadings2 = { "Seria Core", "Seria .NET" };

   private static string[] _books1 = { "GDI Revealed" };
   private static string[] _books2 = { "HTML for the Web", "Zen of CSS Design", "Core JavaServer Faces", ".NET Web Services" };
   private static string[] _books3 = { "Core Java", "Core C# and .NET",  "Core JavaServer Faces" };
   private static string[] _books4 = { "Framework Design Guidelines", ".NET Web Services" };


   private static Product[] _prods1 = { _products[0] };
   private static Product[] _prods2 = { _products[5], _products[6], _products[7], _products[3] };
   private static Product[] _prods3 = { _products[0], _products[1], _products[7] };
   private static Product[] _prods4 = { _products[2], _products[3] };

   public static Product[] GetProducts()
   {
      return _products;
   }

   public static Product GetProductById(int id)
   {
      foreach (Product prod in _products)
      {
         if (prod.Id == id)
            return prod;
      }
      return null;
   }


   public static string[] GetGroups()
   {
      return _groups;
   }

   public static string[] GetSubHeadingsByGroup(string group)
   {
      if (group == "Kategorie")
         return _subheadings1;
      else
         return _subheadings2;
   }

   public static string[] GetProductsBySubHeading(string subheading)
   {
      if (subheading == "Grafika")
         return _books1;
      else if (subheading == "Internet")
         return _books2;
      else if (subheading == "Seria Core")
         return _books3;
      else
         return _books4;
   }

   public static Product[] GetProductObjectsBySubHeading(string subheading)
   {
      if (subheading == "Grafika")
         return _prods1;
      else if (subheading == "Internet")
         return _prods2;
      else if (subheading == "Seria Core")
         return _prods3;
      else
         return _prods4;
   }
}
