using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

/// <summary>
/// Represents a business object.
/// </summary>
public static class Catalog
{

   private static CatalogObject[] _groups = { 
      new CatalogObject(1, "Categories"), new CatalogObject( 2, "Series") };

   private static CatalogObject[] _subheadings = {
      new CatalogObject(10,"Graphics"), new CatalogObject(20,"Internet"),
      new CatalogObject(30,"Core Series"), new CatalogObject(40,".NET Series") };

   private static CatalogObject[] _books = { 
      new CatalogObject(1, "GDI Revealed"), new CatalogObject(2, "HTML for the Web"), 
      new CatalogObject(3, "Zen of CSS Design"), new CatalogObject(5, "Core Java"), 
      new CatalogObject(6, "Core C# and .NET"),  new CatalogObject(7, "Core JavaServer Faces"), 
      new CatalogObject(8, "Framework Design Guidelines"), new CatalogObject(9, ".NET Web Services") };


   public static CatalogObject[] GetGroups()
   {
      
      return _groups;
   }
   public static CatalogObject[] GetSubHeadingsByGroup(int group)
   {
      CatalogObject[] headings = new CatalogObject[2];
      if (group == 1) {
         headings[0] = _subheadings[0];
         headings[1] = _subheadings[1];
      }
      else {
         headings[0] = _subheadings[2];
         headings[1] = _subheadings[3];
      }
      return headings;
   }
   public static CatalogObject[] GetBooksBySubHeadings(int subHeading)
   {
      CatalogObject[] results = null;
      if (subHeading == 10)
      {
         results = new CatalogObject[1];
         results[0] = _books[0];
      }
      else if (subHeading == 20)
      {
         results = new CatalogObject[3];
         results[0] = _books[1];
         results[1] = _books[2];
         results[2] = _books[5];
      }
      else if (subHeading == 30)
      {
         results = new CatalogObject[3];
         results[0] = _books[3];
         results[1] = _books[4];
         results[2] = _books[5];
      }
      else if (subHeading == 40)
      {
         results = new CatalogObject[2];
         results[0] = _books[6];
         results[1] = _books[7];
      }
      return results;
   }

   public static string GetGroupNameById(int id)
   {
      foreach (CatalogObject co in _groups)
      {
         if (co.Id == id)
            return co.Name;
      }
      return "";
   }

   public static string GetSubHeadingNameById(int id)
   {
      foreach (CatalogObject co in _subheadings)
      {
         if (co.Id == id)
            return co.Name;
      }
      return "";
   }

   public static string GetBookNameById(int id)
   {
      foreach (CatalogObject co in _books)
      {
         if (co.Id == id)
            return co.Name;
      }
      return "";
   }
}
