using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class ThemeTester : System.Web.UI.Page
{
   /// <summary>
   /// Ustawienie tematu strony na podstawie wyboru uytkownika
   /// </summary>
   protected void Page_PreInit(object sender, EventArgs e)
   {
      // pobranie tematu z sesji
      string theme = (string)Session["theme"];
      // naley sprawdzi, czy sesja istnieje
      if (theme != null)
      {
         this.Page.Theme = theme;
      }
      else
      {
         //ustawienie tematu domylnego
         this.Page.Theme = "Cool";
      }
   }
   /// <summary>
   /// Przetwarzanie wyboru tematu uytkownika i zapisanie go w stanie sesji
   /// </summary>
   protected void drpThemes_SelectedIndexChanged(object sender, EventArgs e)
   {
      if (drpThemes.SelectedIndex != 0)
      {
         //zapisanie tematu w sesji
         string theme = drpThemes.SelectedItem.Text;
         Session["theme"] = theme;

         //ponowne danie strony 
         string page = Request.Path;
         Server.Transfer(page);
      }
   }
}
