using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using System.IO;

/// <summary>
/// Formularz Web pozwalajcy na przegldanie i pobieranie plikw z serwera.
/// Uytkownik moe rwnie wysya pliki oraz tworzy foldery.
/// </summary>
public partial class FileBrowser : System.Web.UI.Page
{
    /// <summary>
    /// Pobranie cieki foldera do wywietlania i generowanie listy plikw
    /// </summary>
    protected void Page_Load(object sender, EventArgs e)
    {
        string currentRoot = RetrievePathOfFolderToDisplay();
        litLocation.Text = currentRoot;
        GenerateListing(currentRoot);
    }

    /// <summary>
    /// Wywietlenie zawartoci podanego folderu.
    /// </summary>
    private void GenerateListing(string rootpath)
    {
        // na pocztek czyszczenie kontrolki PlaceHolder
        myPlaceHolder.Controls.Clear();

        // wyznaczenie cieki w celu odczytania folderw i plikw
        string path = Server.MapPath("") + "/" + rootpath;

        DirectoryInfo dirInfo = new DirectoryInfo(path);

        // dodanie cza "przejd w gr" jeeli jest potrzebne
        MakeUpOneLevelLink(rootpath);

        // pobranie listy wszystkich folderw
        DirectoryInfo[] folders = dirInfo.GetDirectories();
        // przegldanie kolejnych folderw i ich wywietlanie
        foreach (DirectoryInfo folder in folders)
        {
            DisplayFolder(folder, rootpath);
        }

        // pobranie listy wszystkich plikw w biecej ciece
        FileInfo[] files = dirInfo.GetFiles();
        // przegldanie kolejnych plikw
        foreach (FileInfo file in files)
        {
            DisplayFile(file, rootpath);
        }
    }

    /// <summary>
    /// Pobranie cieki folderu do wywietlenia
    /// </summary>
    private string RetrievePathOfFolderToDisplay()
    {
        string localpath = Request.QueryString["local"];
        // jeeli nie ma adnego cigu, ustawiamy jako gwny katalog uploads
        if (localpath == null)
            return "uploads";
        else
            // usunicie kodowania URL niezbdnego w cigu zapytania
            return Server.UrlDecode(localpath);
    }

    /// <summary>
    /// Wywietlenie odpowiednich kontrolek dla przekazanego folderu
    /// </summary>
    private void DisplayFolder(DirectoryInfo folder, string rootpath)
    {
        // Pobranie nazwy folderu bez cieki
        string shortfolder = Path.GetFileName(folder.FullName);

        // dodanie ikony folderu
        Image img = new Image();
        img.ImageUrl = "images/mime_folder.gif";
        myPlaceHolder.Controls.Add(img);

        // Dodanie spacji nieamicej
        LiteralControl space1 = new LiteralControl("&nbsp;");
        myPlaceHolder.Controls.Add(space1);

        // dodanie cza folderu, dziki czemu uytkownik moe do niego przej
        HyperLink lnk = new HyperLink();
        lnk.Text = shortfolder;
        lnk.NavigateUrl = "FileBrowser.aspx?local=" + Server.UrlEncode(rootpath + "/" + shortfolder);
        myPlaceHolder.Controls.Add(lnk);

        LiteralControl br1 = new LiteralControl("<br/>");
        myPlaceHolder.Controls.Add(br1);
    }

    /// <summary>
    /// Wywietlenie odpowiednich kontrolek dla przekazanego pliku
    /// </summary>
    private void DisplayFile(FileInfo file, string rootpath)
    {
        // Pobranie nazwy pliku bez cieki
        string shortname = Path.GetFileName(file.FullName);

        // dodanie ikony pliku
        Image img = new Image();
        img.ImageUrl = GetIconForExtension(file);
        myPlaceHolder.Controls.Add(img);

        // Dodanie spacji nieamicej
        LiteralControl space2 = new LiteralControl("&nbsp;");
        myPlaceHolder.Controls.Add(space2);

        // Dodanie cza do pliku, dziki czemu uytkownik moe go pobra lub wywietli 
        HyperLink lnk = new HyperLink();
        lnk.Text = shortname;
        // cze folderu musi przekazywa nazw folderu.
        // Poniewa nazwa folderu moe zawiera znaki,
        // ktre nie s dozwolone w cigu zapytania, naley je zakodowa
        lnk.NavigateUrl = Server.UrlDecode(rootpath) + "/" + shortname;
        myPlaceHolder.Controls.Add(lnk);

        // dodanie wielkoci pliku w KB
        long kb = file.Length / 1000;
        LiteralControl size = new LiteralControl(" [" + kb + " KB]");
        myPlaceHolder.Controls.Add(size);

        // dodanie nowego wiersza
        LiteralControl br2 = new LiteralControl("<br/>");
        myPlaceHolder.Controls.Add(br2);
    }

    /// <summary>
    /// Zwraca nazw pliku dla odpowiedniej ikony typu pliku
    /// na podstawie rozszerzenia przekazanego pliku
    /// </summary>
    private string GetIconForExtension(FileInfo file)
    {
        string image = "images/"; 

        string ext = Path.GetExtension(file.FullName).ToLower();

        if (ext == ".txt")
            image += "mime_text.gif";
        else if (ext == ".doc")
            image += "mime_doc.gif";
        else if (ext == ".pdf")
            image += "mime_pdf.gif";
        else if (ext == ".gif" || ext == ".jpg" || ext == ".wmf")
            image += "mime_image.gif";
        else if (ext == ".html" || ext == ".htm" )
            image += "mime_html.gif";
        else
            image += "mime_unknown.gif";

        return image;
    }

    /// <summary>
    /// Utworzenie cza "jeden poziom do gry" (jeeli jest potrzebne dla biecego Makes the "go up a level" link (if needed for the 
    /// current folder) and adds it to the place holder
    /// </summary>
    private void MakeUpOneLevelLink(string currentFolder)
    {
        // Popbaranie poprzedniego folderu
        string previousFolder = GetPreviousFolder(currentFolder);
        // jeeli istnieje poprzedni folder, dodanie cza
        if (previousFolder != "")
        {
            Image imgBack = new Image();
            imgBack.ImageUrl = "images/mime_folder.gif";
            myPlaceHolder.Controls.Add(imgBack);

            HyperLink lnkBack = new HyperLink();
            lnkBack.Text = "..";
            lnkBack.NavigateUrl = "FileBrowser.aspx?local=" + Server.UrlEncode(previousFolder);
            myPlaceHolder.Controls.Add(lnkBack);

            LiteralControl br = new LiteralControl("<br/>");
            myPlaceHolder.Controls.Add(br);
        }
    }

    /// <summary>
    /// Pobranie poprzedniego folderu (z poziomu wyej w hierarchii folderw)
    /// z przekazanej cieki. Jeeli nie ma poprzedniego folderu, zwraca 
    /// pusty cig.
    /// </summary>
    private string GetPreviousFolder(string path)
    {
        int posOfLastSlash = path.LastIndexOf("/");
        if (posOfLastSlash < 0)
            return "";
        string stripped = path.Remove(posOfLastSlash);
        return stripped;
    }

    /// <summary>
    /// Procedura obsugi zdarzenia dla przycisku przesania pliku
    /// </summary>
    protected void btnUpload_Click(object sender, EventArgs e)
    {
        // przezyany plik jest umieszczany w biecym folderze
        string path = RetrievePathOfFolderToDisplay();
        if (fupTest.HasFile)
        {
            string fullname = Server.MapPath(path + "/" + fupTest.FileName);
            if (System.IO.File.Exists(fullname))
            {
                labMessage.Text = "Plik ju istnieje - przesyanie przerwane";
            }
            else
            {
                fupTest.SaveAs(fullname);
                labMessage.Text = "Udane przesanie pliku";
                // powtrne utworzenie listy plikw w celu pokazania przesanego pliku
                GenerateListing(path);
            }
        }
        else
        {
            labMessage.Text = "Nie zosta podany plik";
        }

    }

    /// <summary>
    /// Procedura obsugi przycisku tworzenia nowego folderu
    /// </summary>
    protected void btnNewFolder_Click(object sender, EventArgs e)
    {        
        // pobranie lokalizacji nowego folderu
        string folderLocation = RetrievePathOfFolderToDisplay();
        string fullPath = Server.MapPath(folderLocation) + "/" + txtFolder.Text;
        // utworzenie folderu na serwerze
        Directory.CreateDirectory(fullPath);
        // powtrne utworzenie listy plikw w celu pokazania nowego folderu
        GenerateListing(folderLocation);
    }
}
