﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="CustomNavigationWizard.aspx.cs"
  Inherits="CustomNavigationWizard" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN" "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
  <title>Własny kreator nawigacji</title>
  <link href="chapterStyles.css" type="text/css" rel="stylesheet" />
  <style type="text/css">
    .wizardStepContent { padding: 5px; }
    .wizardNavContent { padding: 4px; }
    </style>
</head>
<body>
  <form id="form1" runat="server">
  <asp:Wizard ID="myWizard" runat="server" HeaderText="Checkout" BackColor="#CCCC99"
    BorderColor="#999999" BorderWidth="1px" Font-Names="Verdana,Arial,Helvetica" Font-Size="Small"
    Height="200">
    <HeaderStyle BackColor="#FFFFFF" Font-Size="Medium" VerticalAlign="Top" />
    <HeaderTemplate>
      <div style="margin: 5px 5px 5px 5px">
        <img src='images/title_checkout_step<%= myWizard.ActiveStepIndex+1 %>.gif' alt='Checkout <%= myWizard.ActiveStep.Title%>' />
      </div>
    </HeaderTemplate>
    <SideBarStyle VerticalAlign="Top" BackColor="#FFFFCC" Font-Size="small" />
    <SideBarTemplate>
      <asp:Panel Style="padding: 10px 10px 10px 10px" ID="panSide" runat="server">
        <asp:DataList ID="SideBarList" runat="server">
          <ItemTemplate>
            <asp:ImageButton ID="SideBarButton" runat="server" CommandName="MoveTo" ImageUrl='<%# GetStepImage((string)Eval("Title"))%>' />
          </ItemTemplate>
          <SelectedItemTemplate>
            <asp:ImageButton ID="SideBarButton" runat="server" CommandName="MoveTo" ImageUrl='<%# GetSelectedStepImage((string)Eval("Title"))%>' />
          </SelectedItemTemplate>
        </asp:DataList>
      </asp:Panel>
    </SideBarTemplate>
    <StepStyle CssClass="wizardStepContent" VerticalAlign="Top" />
    <NavigationStyle BackColor="white" VerticalAlign="Bottom" />
    <NavigationButtonStyle BackColor="#FFFFCC" ForeColor="#666633" />
    <StartNavigationTemplate>
      <asp:Panel ID="panStart" runat="server" CssClass="wizardNavContent">
        <asp:ImageButton runat="server" ID="imgStart" ImageUrl="~/images/button_checkout_start.gif"
          CommandName="MoveNext" AlternateText="Sign-In" />
      </asp:Panel>
    </StartNavigationTemplate>
    <StepNavigationTemplate>
      <asp:Panel ID="panStep" runat="server" CssClass="wizardNavContent">
        <asp:ImageButton runat="server" ID="imgPrev" ImageUrl="~/images/button_checkout_previous.gif"
          CommandName="MovePrevious" AlternateText="Previous" />
        <asp:ImageButton runat="server" ID="imgNext" ImageUrl="~/images/button_checkout_next.gif"
          CommandName="MoveNext" AlternateText="Next" />
      </asp:Panel>
    </StepNavigationTemplate>
    <FinishNavigationTemplate>
      <asp:Panel ID="panFinish" runat="server" CssClass="wizardNavContent">
        <asp:ImageButton runat="server" ID="imgPrevFin" ImageUrl="~/images/button_checkout_previous.gif"
          CommandName="MovePrevious" AlternateText="Previous" />      
        <asp:ImageButton runat="server" ID="imgFinish" ImageUrl="~/images/button_checkout_finish.gif"
          CommandName="MoveFinish" AlternateText="Make Payment" />
      </asp:Panel>
    </FinishNavigationTemplate>
    <WizardSteps>
      <asp:WizardStep ID="WizardStep1" runat="server" Title="Login">
        <asp:Label ID="label1" runat="server">Name</asp:Label>
        <asp:TextBox ID="txtName" runat="server" /><br />
        <asp:Label ID="label2" runat="server">Email</asp:Label>
        <asp:TextBox ID="txtEmail" runat="server" />
      </asp:WizardStep>
      <asp:WizardStep ID="WizardStep2" runat="server" Title="Address">
        <asp:Label ID="label3" runat="server">Address</asp:Label>
      </asp:WizardStep>
      <asp:WizardStep ID="WizardStep3" runat="server" Title="Shipping">
        <asp:Label ID="label4" runat="server">Shipping</asp:Label>
        <asp:DropDownList ID="DropDownList1" runat="server">
          <asp:ListItem>Air Mail</asp:ListItem>
          <asp:ListItem>Fed Ex</asp:ListItem>
        </asp:DropDownList>
      </asp:WizardStep>
      <asp:WizardStep ID="WizardStep4" runat="server" Title="Payment">
        <asp:Label ID="label5" runat="server">Payment</asp:Label>
      </asp:WizardStep>
      <asp:WizardStep ID="WizardStep5" runat="server" Title="Confirmation">
        <asp:Label ID="label6" runat="server">Confirmation</asp:Label>
      </asp:WizardStep>
    </WizardSteps>
  </asp:Wizard>
  </form>
</body>
</html>
