using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;

using net.webservicex.www;

public partial class ShowWeatherControl : System.Web.UI.UserControl
{
   protected void Page_Load(object sender, EventArgs e)
   {
      if (!IsPostBack)
      {
         // uyj biecego ustawienia profilu miasta dla danego uytkownika
         string city = Profile.City;

         // najpierw sprbuj pobra dane z sesji
         // WeatherData today = (WeatherData)Session["Weather"];

         // najpierw sprbuj pobra dane z pamici podrcznej
         WeatherData today = (WeatherData)Cache["Weather" + city];
         if (today == null)
            today = GetWeatherData(city);

         DisplayWeatherData(today);
      }
   }

   private WeatherData GetWeatherData(string city)
   {
      WeatherData today = null;
      try
      {
         // utwrz porednika prognozy pogody
         WeatherForecast weatherService = new WeatherForecast();
         // ustaw czas oczekiwania na 10 sekund (10000 milisekund)
         weatherService.Timeout = 10000;  

         // pobierz prognoz pogody dla danego miasta
         WeatherForecasts forecasts = weatherService.GetWeatherByPlaceName(city);

         // zwr prognoz z biec dat
         return forecasts.Details[0];
      }
      catch (Exception ex)
      {
         labError.Text = ex.Message;
      }
      return today;
   }

   public void DisplayWeatherData(WeatherData today)
   {
      // jeli dane o pogodzie zostay pobrane, wywietl je
      if (today != null)
      {
         string city = Profile.City;
         labCity.Text = city;
         labWeather.Text = today.MinTemperatureF;
         imgWeather.ImageUrl = today.WeatherImage;
         labWeather.Text += "&deg;C / " + today.MaxTemperatureC + "&deg;C";
         labDate.Text = today.Day;

         // zapisz dane o pogodzie w pamici podrcznej
         Cache.Insert("Weather" + city, today, null,
            DateTime.Now.AddMinutes(10.0),
            System.Web.Caching.Cache.NoSlidingExpiration);
      }
   }
}
