using System;
using System.Data;

namespace FourLayer.BusinessEntity
{
   /// <summary>
   /// Encapsulates the data for a single book author
   /// </summary>
   [Serializable]
   public class Author : AbstractEntity
   {

      // data members
      private string _name = "";

      public Author() { }
      public Author(int id, string name)
         : base(id)
      {
         _name = name;
      }

      public int Id
      {
         get { return (int)Key; }
         set { Key = value; }
      }
      public string Name
      {
         get { return _name; }
         set { _name = value; }
      }

      public override string ToString()
      {
         return Id + "," + Name;
      }

      /// <summary>
      /// Determines if this object's state is valid
      /// </summary>
      protected override bool CheckIfSubClassStateIsValid
      {
         get
         {
            if (Name == null)
            {
               AddBrokenRule("Author: Name is null");
               return false;
            }

            if (Name.Length > 0)
               return true;
            else
            {
               AddBrokenRule("Author: Name is empty");
               return false;
            }
         }
      }
   }
}
