using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using System.Web.Profile;

public partial class TestProfileManager : System.Web.UI.Page
{
   protected void Page_Load(object sender, EventArgs e)
   {
      grdProfiles.DataSource = ProfileManager.GetAllProfiles(ProfileAuthenticationOption.Authenticated);
      grdProfiles.DataBind();

      grdAnonProfiles.DataSource = ProfileManager.GetAllProfiles(ProfileAuthenticationOption.Anonymous);
      grdAnonProfiles.DataBind();
   }
   protected void btnDelete_Click(object sender, EventArgs e)
   {
      // usu wszystko, co zostao utworzone dziesi minut temu lub pniej
      DateTime dateToDelete = DateTime.Now.Subtract(new TimeSpan(0,10,0));
      ProfileManager.DeleteInactiveProfiles(ProfileAuthenticationOption.Anonymous, DateTime.Now);

      Response.Redirect("TestProfileManager.aspx");
   }
   protected void grdProfiles_RowCommand(object sender, GridViewCommandEventArgs e)
   {
      // Pobierz nazw uytkownika do usunicia
      if (e.CommandName == "Delete")
      {
         int rowIndex = Convert.ToInt32(e.CommandArgument);
         string username = grdProfiles.Rows[rowIndex].Cells[1].Text;

         ProfileManager.DeleteProfile(username);
         Response.Redirect("TestProfileManager.aspx");
      }
   }
}
