using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using System.IO;

public partial class Site: System.Web.UI.MasterPage
{
   /// <summary>
   /// Podczas adowania zapenij list na podstawie motyww w folderze App_Themes
   /// </summary>
   protected void Page_Load(object sender, EventArgs e)
   {
      // zaaduj dynamicznie list rozwijan tylko za pierwszym razem
      if (!IsPostBack)
      {
         // motywy musz znajdowa si w tej lokalizaji
         string path = Server.MapPath("~/App_Themes");
         // sprawd, czy ta lokalizacja istnieje
         if (Directory.Exists(path))
         {
            // pobierz tablic nazw folderw z motywami
            String[] themeFolders = Directory.GetDirectories(path);
            // przetwrz kady element w tej tablicy
            foreach (String folder in themeFolders)
            {
               // pobierz informacje o nazwie tego foldera
               DirectoryInfo info = new DirectoryInfo(folder);
               // dodaj t nazw foldera do listy rozwijanej
               drpThemes.Items.Add(info.Name);
            }
            // po zaadowaniu motyww do listy, naley oznaczy biecy motyw strony 
            // jako zaznaczony element listy

            // najpierw odszukaj nazw motywu strony wrd elementw listy 
            ListItem item = drpThemes.Items.FindByText(Page.Theme);
            // teraz ustaw wybrany indeks listy (czyli wybierz ten
            // element listy) jako indeks elementu listy, ktry wanie zosta odszukany
            drpThemes.SelectedIndex = drpThemes.Items.IndexOf(item);
         }
      }
   }

   /// <summary>
   /// Funkcja obsugi zdarze dla selektora motyww
   /// </summary>
   protected void drpTheme_selectedChanged(object s, EventArgs e)
   {
      //zapisz motyw w profilu
      string theme = drpThemes.SelectedItem.Text;
      Profile.Theme = theme;
      Profile.Save();

      //ponownie zarzdaj stron
      string page = Request.Path;
      Server.Transfer(page);
   }

}
