<%@ Page Language="C#" AutoEventWireup="true" Theme="WebPartDemo" CodeFile="ChangeDisplayMode.aspx.cs" Inherits="ChangeDisplayMode" %>

<%@ Register Src="controls/CustomersControl.ascx" TagName="CustomersControl" TagPrefix="uc" %>
<%@ Register Src="controls/SearchControl.ascx" TagName="SearchControl" TagPrefix="uc" %>
<%@ Register Src="controls/RecentViewsControl.ascx" TagName="RecentViewsControl"
   TagPrefix="uc" %>
<%@ Register Src="controls/RSSControl.ascx" TagName="RSSControl" TagPrefix="uc" %>
<%@ Register Src="controls/RecentBooksControl.ascx" TagName="RecentBooksControl"
   TagPrefix="uc" %>
<%@ Register Src="controls/MainMenuControl.ascx" TagName="MainMenuControl" TagPrefix="uc" %>
<%@ Register Src="controls/LoginControl.ascx" TagName="LoginControl" TagPrefix="uc" %>

<%@ Register Namespace="Chapter14" TagPrefix="ch14" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
   <title>Zmiana trybu wywietlania</title>
   <link href="chapterStyles.css" type="text/css" rel="stylesheet"  />
</head>
<body id="body1" runat="server" >
   <form id="form1" runat="server">
      <asp:WebPartManager ID="partManager" runat="server" />
      <div id="container">
         <div id="header">
            <div id="theme">
               Tryb skadnikw Web Part:
               <asp:DropDownList ID="drpWebPartMode" runat="server" 
                  AutoPostBack="true"
                  OnSelectedIndexChanged="drpWebPartMode_SelectedIndexChanged" />
            </div>
            
            <div id="logo">
               <asp:Image runat="server" ID="imgLogo" SkinID="logo" />
            </div>
         </div>
         <div id="sideArea">
            <asp:WebPartZone ID="zoneSide" runat="server" 
                  Padding="6" WebPartVerbRenderMode="TitleBar"
                  PartChromeType="TitleOnly"  Width="14em" CloseVerb-Text="Zamknij" MinimizeVerb-Text="Minimalizuj">
               <ZoneTemplate>
                  <uc:MainMenuControl ID="myMenu" runat="server" Title="Menu"/>      
                  <uc:LoginControl ID="myLogin" runat="server" 
                     Title="Biecy uytkownik" />            
                  <uc:SearchControl ID="mySearch" runat="server" 
                     Title="Szukanie"/>            
                  <uc:CustomersControl ID="myCustomers" runat="server" 
                     Title="Moi klienci" />
               </ZoneTemplate> 
            </asp:WebPartZone>    
         </div>
         <div id="mainArea">
            <asp:EditorZone ID="editZone" runat="server" Width="300px">
               <ZoneTemplate>
                  <asp:PropertyGridEditorPart ID="partProp" runat="server" />
               </ZoneTemplate>
            </asp:EditorZone>    
            <asp:WebPartZone ID="zoneMain" runat="server" 
                  WebPartVerbRenderMode="Menu"               
                  Padding="6" PartChromeType="TitleOnly">
               <ZoneTemplate>
                  <uc:RecentBooksControl ID="RecentBooksControl1" runat="server" 
                     Title="Najnowsze ksiki" />
                  <uc:RSSControl ID="RSSControl1" runat="server"
                     Title="Najlepiej sprzedawane ksiki informatyczne w Amazonie"
                     Description="Najlepiej sprzedawane ksiki informatyczne w Amazonie"                     
                     XmlUrl="~/amazonRSS.xml" 
                     XsltUrl="~/RssTransformAmazon.xsl" />
                  <uc:RSSControl ID="myPearson" runat="server"
                     Title="Nowoci wydawnictwa Pearson"
                     Description="Nowoci wydawnictwa Pearson" 
                     CatalogIconImageUrl="~/images/webpartNews.gif"
                     TitleIconImageUrl="~/images/webpartNews.gif"
                     XmlUrl="~/pearsonRSS.xml" 
                     XsltUrl="~/RssTransformPearson.xsl" />   
               </ZoneTemplate>
            </asp:WebPartZone>
         </div>
         <div id="footer">
            <p>
               Ta strona nie jest prawdziwa. Jest jedynie przykadem z ksiki o ASP.NET wydawnictwa Helion.</p>
         </div>
      </div>

      <asp:Label ID="labMsg" runat="Server" />
   </form>
</body>
</html>

