using System;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;

/// <summary>
/// Klasa bazowa dla skadnikw web part bazujcych na kontrolkach uytkownika
/// </summary>
public abstract class CustomWebPartBase : System.Web.UI.UserControl, IWebPart
{
   private string _description = "";
   private string _title = "";
   protected string _subtitle = "";
   private string _titleIconImageUrl = "";
   private string _catalogIconImageUrl = "";
   private string _titleUrl = "";

   public CustomWebPartBase()
   {
      _titleIconImageUrl = IconFileName;
      _catalogIconImageUrl = IconFileName;
   }

   /// <summary>
   /// 
   /// </summary>
   protected abstract string IconFileName
   {
      get ;
   }

   #region IWebPart Members

   public string CatalogIconImageUrl
   {
      get { return _catalogIconImageUrl; }
      set { _catalogIconImageUrl = value; }
   }

   public string Description
   {
      get { return _description; }
      set { _description = value; }
   }

   public string Subtitle
   {
      get { return _subtitle; }
   }

   public string Title
   {
      get { return _title; }
      set { _title = value; }
   }

   public string TitleIconImageUrl
   {
      get { return _titleIconImageUrl; }
      set { _titleIconImageUrl = value; }
   }

   public string TitleUrl
   {
      get { return _titleUrl; }
      set { _titleUrl = value; }
   }

   #endregion
}
