using System;
using System.Collections;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;

using FourLayer.ApplicationLogic;
using FourLayer.BusinessEntity;

namespace Chapter14
{
   public class BookListViewer : WebPart
   {
      private Publisher _publisher = null;
      //private ISelectPublisher _pubInterface;

      public BookListViewer()
      {
         Title = "Poka ksiki";
         Description = "Poka wszystkie ksizki";
         TitleIconImageUrl = "images/webpartBooks.gif";
         CatalogIconImageUrl = "images/webpartBooks.gif";         
      }

      /// <summary>
      /// Wywietla zawarto HTML kontrolki
      /// </summary>
      protected override void RenderContents(HtmlTextWriter writer)
      {
         EntityCollection<Book> books;
         if (PublisherToUse == null)
            books = BookCatalogLogic.GetAllBooks();
         else
            books = BookCatalogLogic.GetBooksByPublisher(PublisherToUse.Id);

         int max = 10;
         if (max > books.Count) max = books.Count;

         string output = "<div id='listContainer'>";
         for (int i = 0; i < max; i++)
         {
            Book book = books[i];
            output += "<p><a href=BookDetails.aspx?id=";
            output += book.Isbn + ">";
            output += book.Title;
            output += "></p>";
         }
         output += "</div>";
         writer.Write(output);
      }

      
      public override WebPartVerbCollection Verbs
      {
         get
         {
            // utwrz nowy zbir czasownikw
            ArrayList verbs = new ArrayList();
            // pobierz wszystkich wydawcw
            EntityCollection<Publisher> pubs = BookCatalogLogic.GetAllPublishers();

            // z kadego wydawcy utwrz czasownik
            foreach (Publisher p in pubs)
            {
               WebPartVerb verb = new WebPartVerb(p.Id.ToString(), 
                  new WebPartEventHandler(ChangePublisher));
               verb.Text = p.Name;
               verb.Description = "Poka ksiki wydawcy " + p.Name;
               // jeli jest to wydawca biecy, zaznacz go
               if (PublisherToUse != null && p.Name == PublisherToUse.Name)
                  verb.Checked = true;
               // dodaj nowy czasownik do zbioru
               verbs.Add(verb);
            }
            // utwrz nowy zbir czasownikw z nowymi czasownikami 
            // dodanymi do ju istniejcych czasownikw
            return new WebPartVerbCollection(base.Verbs, verbs);
         }
      }
      
      public void ChangePublisher(object o, WebPartEventArgs e)
      {
         WebPartVerb verb = (WebPartVerb)o;
         PublisherToUse = BookCatalogLogic.GetPublisherByName(verb.Text);
      }
       

      // [Personalizable, WebBrowsable]
      public Publisher PublisherToUse
      {
         get { return _publisher; }
         set { 
            _publisher = value;
            Title = "Poka ksiki wydawcy " + _publisher.Name;
         }
      }
       
/*
      [ConnectionConsumer("SelectedPublisherConnectionPoint")]
      public void GetProvider(ISelectPublisher pubInterface)
      {
         _pubInterface = pubInterface;
      }

      protected override void OnPreRender(EventArgs e)
      {
         if (_pubInterface != null)
         {
            PublisherToUse = _pubInterface.ChosenPublisher;
         }
      }
 */
   }
}