using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class UserManager : System.Web.UI.Page
{
   protected void Page_Load(object sender, EventArgs e)
   {
      if (!IsPostBack)
      {
         panSingle.Visible = false;
         panNew.Visible = false;
      }
      
   }
   protected void grdUsers_SelectedIndexChanged(object sender, EventArgs e)
   {
      object userKey = grdUsers.SelectedDataKey.Values[0];
      MembershipUser user =  Membership.GetUser(userKey);

      if (user != null)
      {
         txtEditEmail.Text = user.Email;
         txtEditComments.Text = user.Comment;

         panSingle.Visible = true;
      }
      

      
   }
   protected void btnEdit_Click(object sender, EventArgs e)
   {
      /*
      MembershipUserCollection allUsers = Membership.GetAllUsers();

      string currentUserName = (string)grdUsers.SelectedDataKey["UserName"];
      MembershipUser user = allUsers[currentUserName];
       * */

      object userKey = grdUsers.SelectedDataKey.Values[0];
      MembershipUser user = Membership.GetUser(userKey);


      user.Email = txtEditEmail.Text;
      user.Comment = txtEditComments.Text;

      Membership.UpdateUser(user);
   }

   protected void btnAdd_Click(object sender, EventArgs e)
   {
      MembershipCreateStatus status;
      Membership.CreateUser(txtUser.Text, txtPass.Text, txtEmail.Text,
         txtPassQuestion.Text, txtPassAnswer.Text, true, out status);
      if (status == MembershipCreateStatus.Success)
         labStatus.Text = "Uytkownika utworzono pomylnie";
      else
         labStatus.Text = GetErrorMessage(status);
   }
   public string GetErrorMessage(MembershipCreateStatus status)
   {
      switch (status)
      {
         case MembershipCreateStatus.DuplicateUserName:
            return "Nazwa uytkownika ju istnieje. Prosz wprowadzi inn nazw uytkownika.";

         case MembershipCreateStatus.DuplicateEmail:
            return "Nazwa uytkownika dla podanego adresu e-mail ju istnieje. Prosz wprowadzi inny adres e-mail.";

         case MembershipCreateStatus.InvalidPassword:
            return "Podane haso jest nieprawidowe. Prosz wprowadzi prawidowe haso.";

         case MembershipCreateStatus.InvalidEmail:
            return "Podany adres e-mail jest nieprawidowy. Prosz go sprawdzi sprawdzi i sprbowa ponownie.";

         case MembershipCreateStatus.InvalidAnswer:
            return "Podana odpowied jest nieprawidowa. Prosz j sprawdzi i sprbowac ponownie.";

         case MembershipCreateStatus.InvalidQuestion:
            return "Podane pytanie pomocnicze jest nieprawidowe. Prosz je sprawdzi i sprbowac ponownie.";

         case MembershipCreateStatus.InvalidUserName:
            return "Podana nazwa uytkownika jest nieprawidowa. Prosz j sprawdzi i sprbowac ponownie.";

         case MembershipCreateStatus.ProviderError:
            return "Dostawca uwierzytelnie zwrci bd. Prosz sprawdzi wprowadzone dane i sprbowa ponownie. Jeli problem bdzie si powtarza, prosz skontaktowa si z administratorem systemu.";

         case MembershipCreateStatus.UserRejected:
            return "danie utworzenia uytkownika zostao anulowane. Prosz sprawdzi wprowadzone dane i sprbowa ponownie. Jeli problem bdzie si powtarza, prosz skontaktowa si z administratorem systemu.";

         default:
            return "Wystpi nieznany bd. Prosz sprawdzi wprowadzone dane i sprbowa ponownie. Jeli problem bdzie si powtarza, prosz skontaktowa si z administratorem systemu.";
      }
   }
   protected void lnkNew_Click(object sender, EventArgs e)
   {
      panNew.Visible = true;
      lnkNew.Visible = false;
   }
}
