using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class RoleManager : System.Web.UI.Page
{
   protected void Page_Load(object sender, EventArgs e)
   {
      labName.Text = User.Identity.Name;
      if (! IsPostBack)
      {
         btnSaveRoles.Visible = false;
      }
   }

   /// <summary>
   /// Z listy wybrano uytkownika, a zatem sprawd odpowiednie role na licie
   /// </summary>
   protected void drpUsers_SelectedIndexChanged(object sender, EventArgs e)
   {
      btnSaveRoles.Visible = true;

      // sprawd, ktrego uytkownika wybrano
      string username = drpUsers.SelectedValue;

      // pobierz role dla wybranego uytkownika
      string[] userRoles = Roles.GetRolesForUser(username);

      // przejd przez wszystkie pozycje na licie pl wyboru rl
      foreach (ListItem item in chkRoles.Items)
      {
         string rolename = item.Value;
         // if this role is a user role, then select it
         if (Roles.IsUserInRole(username, rolename))
            item.Selected = true;
         else
            item.Selected = false;
      }
   }

   /// <summary>
   /// Zapisz role uytkownika
   /// </summary>
   protected void btnSaveRoles_Click(object sender, EventArgs e)
   {
      // sprawd, ktrego uytkownika wybrano
      string username = drpUsers.SelectedValue;

      // przejd przez wszystkie pola wyboru
      foreach (ListItem item in chkRoles.Items)
      {
         string rolename = item.Value;
         if (item.Selected)
         {
            // uytkownika naley doda do roli tylko wtedy, gdy nie ma go jeszcze w zbiorze danych
            if (! Roles.IsUserInRole(username, rolename))
               Roles.AddUserToRole(username, rolename);
         }
         else
         {
            // uytkownika naley usun z roli tylko wtedy, gdy znajduje si w zbiorze danych
            if (Roles.IsUserInRole(username, rolename))
               Roles.RemoveUserFromRole(username, rolename);
         }
      }
   }

   /// <summary>
   /// Dodaj now rol
   /// </summary>
   protected void btnAddRole_Click(object sender, EventArgs e)
   {
      string rolename = txtRole.Text;
      if (rolename.Length == 0) return;

      // dodaj rol tylko wtedy, gdy jeszcze nie istnieje
      if (!Roles.RoleExists(rolename))
      {
         Roles.CreateRole(rolename);
         chkRoles.DataBind();
      }
   }

   /// <summary>
   /// Usu istniejc rol
   /// </summary>
   protected void btnDeleteRole_Click(object sender, EventArgs e)
   {
      string rolename = txtDeleteRole.Text;
      if (rolename.Length == 0) return;
      // usu rol tylko wtedy, gdy istnieje
      if (Roles.RoleExists(rolename))
      {
         // usu wszystkich uytkownikw z tej roli
         MembershipUserCollection users = Membership.GetAllUsers();
         foreach (MembershipUser user in users)
         {
            string username = user.UserName;
            // uytkownika naley usun z roli tylko wtedy, gdy znajduje si w zbiorze danych
            if (Roles.IsUserInRole(username, rolename))
               Roles.RemoveUserFromRole(username, rolename);
         }
         
         // teraz usu rol
         Roles.DeleteRole(rolename);
         chkRoles.DataBind();
      }
   }
}
