using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using FourLayer.ApplicationLogic;
using FourLayer.BusinessEntity;

using System.Web.Caching;

public partial class UsingCache : System.Web.UI.Page
{
   protected void Page_Load(object sender, EventArgs e)
   {
      EntityCollection<Publisher> publishers;
      publishers = (EntityCollection<Publisher>)Cache["Publishers"];
      if (publishers == null)
      {
         BookCatalogLogic bcl = new BookCatalogLogic();
         publishers = bcl.GetAllPublishers();
         //Cache["Publishers"] = publishers;
         //Cache.Insert("Publishers", publishers, null, Cache.NoAbsoluteExpiration, TimeSpan.FromMinutes(2));
         Cache.Insert("Publishers", publishers, null, DateTime.Now.AddMinutes(2.0), Cache.NoSlidingExpiration);
         labMsg.Text = "Pobieranie wydawcw z bazy danych";
      }
      else
         labMsg.Text = "Pobieranie wydawcw z pamici podrcznej";

      grdPublishers.DataSource = publishers;
      grdPublishers.DataBind();
   }
   protected void btnShow_Click(object sender, EventArgs e)
   {

   }

}
