using System;
using System.Data;
using System.Data.Common;

namespace TwoLayer.DataAccess
{

   /// <summary>
   /// Oglny opis BookDA
   /// </summary>
   public class BookDA : AbstractDA
   {
      protected override string SelectStatement
      {
         get
         {
            return "SELECT ISBN,Title,PublisherName,Books.PublisherId,Books.SeriesId,Books.CategoryId,YearPublished,BriefDescription,CategoryName,SeriesName FROM Series  INNER JOIN (Publishers INNER JOIN (Categories INNER JOIN Books ON Categories.CategoryId = Books.CategoryId) ON Publishers.PublisherId = Books.PublisherId) ON Series.SeriesId = Books.SeriesId;";
         }
      }

      /// <summary>
      /// Zwraca ca okrelon stron danych
      /// </summary>
      public DataTable GetAll(int startRowIndex, int rowsToRetrieve)
      {
         // uyj procedury skadowanej w celu pobrania wycznie potrzebnych danych
         string storedProc = "GetAllBooksByPage";

         // utwrz tablic parametrw
         DbParameter[] parameters = new DbParameter[] {
		   MakeParameter("@startRowIndex", startRowIndex, DbType.Int32),
         MakeParameter("@rowsToRetrieve", rowsToRetrieve, DbType.Int32)
	   };

         // zwr wynik
         return GetDataTable(storedProc, CommandType.StoredProcedure, parameters);
      }

      /// <summary>
      /// Zwraca ca okrelon stron danych
      /// </summary>
      public DataTable GetAll(string sortExpression)
      {
         string sql = SelectStatement;
         if (sortExpression.Length > 0)
            sql += " ORDER BY " + sortExpression;
         return GetDataTable(sql, null);
      }


      /// <summary>
      /// Zwraca cakowit liczb rekordw z ksikami
      /// </summary>
      /// <returns></returns>
      public int CountBooks()
      {
         string sql = "SELECT COUNT(*) FROM Books";

         return (int)RunScalar(sql, null);
      }

      /// <summary>
      /// Zwraca tabel z danymi zawierajc informacje o tabeli wydawcy dla okrelonego identyfikatora.
      /// Ten zbir danych bdzie zawiera 0 lub 1 wiersz danych.
      /// </summary>
      public override DataTable GetById(object oId)
      {
         string isbn = (string)oId;

         // utwrz sparametryzowan instrukcj zapytania
         string sql = SelectStatement + " WHERE ISBN=@isbn";

         // utwrz tablic parametrw
         DbParameter[] parameters = new DbParameter[] {
			MakeParameter("@isbn", isbn, DbType.String)
															};
         // zwr wynik
         return GetDataTable(sql, parameters);
      }

      /// <summary>
      /// Aktualizuje wybrane wartoci ksiki
      /// </summary>
      public void UpdateBook(string isbn, string title, int publisherId, int categoryId, int seriesId, int yearPublished, string briefDescription)
      {
         string sql = "UPDATE Books SET Title=@Title,PublisherId=@PublisherId,";
         sql += "CategoryId=@CategoryId,SeriesId=@SeriesId,";
         sql += "YearPublished=@YearPublished,BriefDescription=@BriefDescription";
         sql += " WHERE ISBN=@isbn";

         // utwrz tablic parametrw
         DbParameter[] parameters = new DbParameter[] {
		   MakeParameter("@isbn", isbn, DbType.String),
         MakeParameter("@Title", title, DbType.String),
         MakeParameter("@PublisherId", publisherId, DbType.Int32),
         MakeParameter("@SeriesId", seriesId, DbType.Int32),
         MakeParameter("@CategoryId", categoryId, DbType.Int32),
         MakeParameter("@YearPublished", yearPublished, DbType.Int32),
         MakeParameter("@BriefDescription", briefDescription, DbType.String)
														   };
         // uruchom okrelon instrukcj
         RunNonQuery(sql, parameters);
      }

      /// <summary>
      /// Aktualizuje wybrane wartoci ksiki
      /// </summary>
      public void InsertBook(string isbn, string title, int publisherId, int categoryId, int seriesId, int yearPublished, string briefDescription)
      {
         string sql = "INSERT INTO Books (ISBN,Title,PublisherId,CategoryId,SeriesId,YearPublished,BriefDescription)";
         sql += " VALUES (@Isbn,@Title,@PublisherId,@CategoryId,@SeriesId,@YearPublished,@BriefDescription)";

         // utwrz tablic parametrw
         DbParameter[] parameters = new DbParameter[] {
		   MakeParameter("@Isbn", isbn, DbType.String),
         MakeParameter("@Title", title, DbType.String),
         MakeParameter("@PublisherId", publisherId, DbType.Int32),
         MakeParameter("@SeriesId", seriesId, DbType.Int32),
         MakeParameter("@CategoryId", categoryId, DbType.Int32),
         MakeParameter("@YearPublished", yearPublished, DbType.Int32),
         MakeParameter("@BriefDescription", briefDescription, DbType.String)
														   };
         // uruchom okrelon instrukcj
         RunNonQuery(sql, parameters);
      }

      public void DeleteBook(string isbn)
      {
         string sql = "DELETE FROM Books WHERE Isbn=@Isbn";

         // utwrz tablic parametrw
         DbParameter[] parameters = new DbParameter[] {
            MakeParameter("@Isbn", isbn, DbType.String)
			};

         // uruchom okrelon instrukcj
         RunNonQuery(sql, parameters);
      }

      /// <summary>
      /// Zwraca tabel z danymi zawierajc informacje o tabeli wydawcy dla okrelonego identyfikatora.
      /// Ten zbir danych bdzie zawiera 0 lub 1 wiersz danych.
      /// </summary>
      public DataTable GetBooksByPublisher(int id)
      {
         /// utwrz sparametryzowan instrukcj zapytania
         string sql = SelectStatement + " WHERE Books.PublisherId=@id";

         // utwrz tablic parametrw
         DbParameter[] parameters = new DbParameter[] {
		   MakeParameter("@id", id, DbType.Int32)
														   };
         // zwr wynik
         return GetDataTable(sql, parameters);
      }
   }
}