using System;
using System.Web;

using FourLayer.BusinessEntity;

namespace FourLayer.DataAccessObject
{
   /// <summary>
   /// Hermetyzuje pami podrczn rodowiska ASP.NET
   /// </summary>
   public static class DataCache<T> where T : AbstractEntity
   {
      public static void AddCollection(string key, EntityCollection<T> item)
      {
         // mona te zdefiniowa czas wyganicia
         HttpContext.Current.Cache.Insert(key, item);
      }

      public static void Remove(string key)
      {
         HttpContext.Current.Cache.Remove(key);
      }

      public static EntityCollection<T> RetrieveCollection(string key)
      {
         return (EntityCollection<T>)HttpContext.Current.Cache[key];
      }

      public static void AddEntity(string key, T entity)
      {
         HttpContext.Current.Cache.Insert(key, entity);
      }
      public static T RetrieveEntity(string key)
      {
         return (T)HttpContext.Current.Cache[key];
      }
   }
}