using System;
using System.Data;
using System.Data.Common;
using System.Collections.Generic;

using FourLayer.BusinessEntity;

namespace FourLayer.DataAccessObject
{

   /// <summary>
   /// oglny opis PublisherDAO
   /// </summary>
   public class CategoryDAO : AbstractDAO<Category>
   {
      public CategoryDAO()
      {
      }

      protected override string SelectStatement
      {
         get { return "SELECT CategoryId, CategoryName FROM Categories"; }
      }
      protected override string PrimaryKeyName
      {
         get { return "CategoryId"; }
      }
      public override bool IsGetAllCached
      {
         get { return true; }
      }
      public override string CacheName
      {
         get { return "Categories"; }
      }

      protected override Category CreateAndFillEntity(DbDataReader recordJustRead)
      {
         // pobierz wartoci rekordw i umie je w zmiennych tymczasowych
         int id = recordJustRead.GetInt32(0);
         string name = recordJustRead.GetString(1);

         // utwrz i wypenij obiekt na podstawie danych
         Category category = new Category(id, name);
         return category;
      }

      public override DataTable AdaptCollectionToDataTable(EntityCollection<Category> collection)
      {
         DataTable dt = new DataTable();
         dt.Columns.Add(new DataColumn("Id", Type.GetType("System.Int32")));
         dt.Columns.Add(new DataColumn("Name", Type.GetType("System.String")));

         foreach (Category c in collection)
         {
            DataRow dr = dt.NewRow();
            dr[0] = c.Id;
            dr[1] = c.Name;
            dt.Rows.Add(dr);
         }
         return dt;
      }

      public override void Update(Category category)
      {
         string sql = "UPDATE Categories SET CategoryName=@CategoryName";
         sql += " WHERE CategoryId=@CategoryId";

         // utwrz tablic parametrw
         DbParameter[] parameters = new DbParameter[] {
            DatabaseActions.MakeParameter("@CategoryId", category.Id, DbType.Int32),
            DatabaseActions.MakeParameter("@CategoryName", category.Name, DbType.String)
			};

         // uruchom okrelon instrukcj
         DatabaseActions.RunNonQuery(sql, parameters);
      }

      public override void Insert(Category category)
      {
         string sql = "INSERT INTO Categories (CategoryName) ";
         sql += " VALUES (@CategoryName)";

         // utwrz tablic parametrw
         DbParameter[] parameters = new DbParameter[] {
            DatabaseActions.MakeParameter("@CategoryName", category.Name, DbType.String)
			};

         // uruchom okrelon instrukcj
         DatabaseActions.RunNonQuery(sql, parameters);
      }

      public override void Delete(Category category)
      {
         string sql = "DELETE FROM Categories WHERE CategoryId=@CategoryId";

         // utwrz tablic parametrw
         DbParameter[] parameters = new DbParameter[] {
            DatabaseActions.MakeParameter("@CategoryId", category.Id, DbType.Int32)
			};

         // uruchom okrelon instrukcj
         DatabaseActions.RunNonQuery(sql, parameters);
      }
   }
}