using System;
using System.Data;
using System.Data.Common;
using System.Configuration;
using System.Web.Configuration;
using System.Collections.Generic;

using FourLayer.BusinessEntity;

namespace FourLayer.DataAccessObject
{
   /// <summary>
   /// Oglny opis DatabaseActions
   /// </summary>
   public static class DatabaseActions
   {
      
      /// <summary>
      /// Uruchamia zapytanie SQL, ktre nie zwraca danych
      /// </summary>
      public static void RunNonQuery(string sql, DbParameter[] parameters)
      {
         // utwrz poczenie niezalene od dostawcy
         using (DbConnection conn = Factory.CreateConnection())
         {
            conn.ConnectionString = ConnectionSetting.ConnectionString;

            // utwrz instrukcj niezalen od dostawcy
            DbCommand cmd = Factory.CreateCommand();
            cmd.Connection = conn;
            cmd.CommandText = sql;

            // dodaj parametry
            if (parameters != null)
            {
               foreach (DbParameter p in parameters)
                  cmd.Parameters.Add(p);
            }

            try
            {
               conn.Open();
               cmd.ExecuteNonQuery();
            }
            catch (Exception ex)
            {
               // wszystkie bdy bd obsugiwane przez niestandardow procedur obsugi wyjtkw
           
               TwoLayer.DataAccess.DataAccessExceptionHandler.HandleException(ex.Message);
            }
         }
      }

      /// <summary>
      /// Uruchamia skalar zwracajcy zapytanie SQL
      /// </summary>
      public static object RunScalar(string sql, DbParameter[] parameters)
      {
         object scalar = null;

         // utwrz poczenie niezalene od dostawcy
         using (DbConnection conn = Factory.CreateConnection())
         {
            conn.ConnectionString = ConnectionSetting.ConnectionString;

            // utwrz instrukcj niezalen od dostawcy
            DbCommand cmd = Factory.CreateCommand();
            cmd.Connection = conn;
            cmd.CommandText = sql;

            // dodaj parametry
            if (parameters != null)
            {
               foreach (DbParameter p in parameters)
                  cmd.Parameters.Add(p);
            }

            try
            {
               conn.Open();
               scalar = cmd.ExecuteScalar();
            }
            catch (Exception ex)
            {
               // wszystkie bdy bd obsugiwane przez niestandardow procedur obsugi wyjtkw
               TwoLayer.DataAccess.DataAccessExceptionHandler.HandleException(ex.Message);
            }
            return scalar;
         }
      }

      /// <summary>
      /// Waciwo prywatna zwracajca parametry acucha poczenia z pliku web.config
      /// </summary>
      public static ConnectionStringSettings ConnectionSetting
      {
         get
         {
            return WebConfigurationManager.ConnectionStrings["BookCatalog"];

         }
      }

      /// <summary>
      /// Waciwo prywatna zwracajca odpowiedni DbProviderFactory
      /// </summary>
      public static DbProviderFactory Factory
      {
         get
         {
            string connString = ConnectionSetting.ConnectionString;
            string invariantName = ConnectionSetting.ProviderName;

            // sprawd, czy nazwa dostawcy jest obsugiwana
            DataTable providers = DbProviderFactories.GetFactoryClasses();
            DataRow[] foundArray = providers.Select("InvariantName='" + invariantName + "'");
            if (foundArray.Length == 0)
            {
               // wszystkie bdy bd obsugiwane przez niestandardow procedur obsugi wyjtkw
               string msg = "[AbstractDA] Data Provider " + invariantName + " not found";
               TwoLayer.DataAccess.DataAccessExceptionHandler.HandleException(msg);
            }

            // pobierz odpowiedni fabryke dostawcw
            return DbProviderFactories.GetFactory(invariantName);
         }
      }

      /// <summary>
      /// Utwrz niezaleny od dostawcy obiekt DbParameter
      /// </summary>
      public static DbParameter MakeParameter(string name, object value, DbType paramType)
      {
         DbParameter param = MakeParameter(name, value);
         param.DbType = paramType;
         return param;
      }
      /// <summary>
      /// Utwrz niezaleny od dostawcy obiekt DbParameter
      /// </summary>
      public static DbParameter MakeParameter(string name, object value)
      {
         DbParameter param = Factory.CreateParameter();
         param.ParameterName = name;
         param.Value = value;
         return param;
      }
   }
}