using System;
using System.Data;

namespace FourLayer.BusinessEntity
{
   /// <summary>
   /// Hermetyzyje dane jednego autora ksiki
   /// </summary>
   [Serializable]
   public class Author : AbstractEntity
   {

      // dane skadowe
      private string _name = "";

      public Author() { }
      public Author(int id, string name)
         : base(id)
      {
         _name = name;
      }

      public int Id
      {
         get { return (int)Key; }
         set { Key = value; }
      }
      public string Name
      {
         get { return _name; }
         set { _name = value; }
      }

      public override string ToString()
      {
         return Id + "," + Name;
      }

      /// <summary>
      /// Sprawdza, czy stan danego obiektu jest prawidowy
      /// </summary>
      protected override bool CheckIfSubClassStateIsValid
      {
         get
         {
            if (Name == null)
            {
               AddBrokenRule("Autor: Nazwa nie ma wartoci");
               return false;
            }

            if (Name.Length > 0)
               return true;
            else
            {
               AddBrokenRule("Autor: Nazwa jest pusta");
               return false;
            }
         }
      }
   }
}
