using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;

using FourLayer.ApplicationLogic;
using FourLayer.BusinessEntity;

public partial class ExtenderTesterNoAtlas : System.Web.UI.Page
{
   /// <summary>
   /// Obsuguje zdarzenia zwizane z wybieraniem przez uytkownika ksiek w kontrolce GridView
   /// </summary>
   protected void grdBookList_Selected(object sender, EventArgs e)
   {
      string isbn = (string)grdBookList.SelectedDataKey.Value;

      BookCatalogLogic logic = new BookCatalogLogic();
      Book book = logic.GetBookByIsbn(isbn);
      if (book != null) DisplayBook(book);
   }

   /// <summary>
   /// Obsuga zdarzenia zwizanego z klikniciem przycisku szukania
   /// </summary>
   protected void btnSearch_Click(object sender, EventArgs e)
   {
      // sprbuj odczyta ksik na podstawie wprowadzanego tekstu
      BookCatalogLogic logic = new BookCatalogLogic();
      EntityCollection<Book> books = logic.GetBooksByTitle(txtSearch.Text);
      // jeli ksika zostaa odnaleziona, wywietl j w panelu
      if (books == null || books.Count <= 0)
         labNotFound.Text = "Ksiki nie odnaleziono";
      else
         DisplayBook(books[0]);
   }

   /// <summary>
   /// Wywietla informacje o ksice w panelu
   /// </summary>
   private void DisplayBook(Book book)
   {
      labNotFound.Text = "";
      labBookTitle.Text = book.Title;
      labBookAuthors.Text = book.AuthorsCommaList;
      labBookPublisher.Text = book.BookPublisher.Name;
      labBookDesc.Text = book.BriefDescription;
   }
}
