using System;
using System.Data;
using System.Data.Common;
using System.Collections.Generic;

using FourLayer.BusinessEntity;

namespace FourLayer.DataAccessObject
{

   /// <summary>
   /// Obiekt dostpu do danych dla kart klienta
   /// </summary>
   public class CustomerCardDAO : AbstractDAO<CustomerCard>
   {
      public CustomerCardDAO()
      {
      }

      protected override string SelectStatement
      {
         get { return "SELECT CardNumber,CardType,CardName,ExpDate,CreditLimit,Balance,Holds,IsCancelled FROM CustomerCards"; }
      }
      protected override string PrimaryKeyName
      {
         get { return "CardNumber"; }
      }
      public override bool IsGetAllCached
      {
         get { return true; }
      }
      public override string CacheName
      {
         get { return "CustomerCards"; }
      }

      protected override CustomerCard CreateAndFillEntity(DbDataReader recordJustRead)
      {
         // pobierz wartoci rekordw u umie je w zmiennych tymczasowych
         string cardNumber = recordJustRead.GetString(0);
         string cardName = recordJustRead.GetString(1);
         string sCardType = recordJustRead.GetString(2);
         CustomerCardTypes cardType = ConvertStringToCardType(sCardType);
         DateTime expDate = recordJustRead.GetDateTime(3);
         decimal creditLimit = recordJustRead.GetDecimal(4);
         decimal balance = recordJustRead.GetDecimal(5);
         decimal holds = recordJustRead.GetDecimal(6);
         bool isCancelled = recordJustRead.GetBoolean(7);

         // utwrz i zapenij obiekty na podstawie danych
         CustomerCard card = new CustomerCard(cardNumber, cardName, cardType, expDate,
            creditLimit, balance, holds, isCancelled);
         return card;
      }

      private CustomerCardTypes ConvertStringToCardType(string sType)
      {
         if (sType == "MAST")
            return CustomerCardTypes.Mastercard;
         else if (sType == "VISA")
            return CustomerCardTypes.Visa;
         else if (sType == "AMEX")
            return CustomerCardTypes.AmericanExpress;
         else
            return CustomerCardTypes.Discovery;
      }

      public override DataTable AdaptCollectionToDataTable(EntityCollection<CustomerCard> collection)
      {
         DataTable dt = new DataTable();
         dt.Columns.Add(new DataColumn("CardType", Type.GetType("System.String")));
         dt.Columns.Add(new DataColumn("CardName", Type.GetType("System.String")));

         foreach (CustomerCard cc in collection)
         {
            DataRow dr = dt.NewRow();
            dr[0] = cc.CardNumber;
            dr[1] = cc.CardName;
            dt.Rows.Add(dr);
         }
         return dt;
      }

      public override void Update(CustomerCard card)
      {
         // do zrobienia
      }
      public void UpdateBalanceHold(CustomerCard card)
      {
         string sql = "UPDATE CustomerCards SET Balance=@Balance,Holds=@Holds";
         sql += " WHERE CardNumber=@CardNumber";

         // utwrz tablic parametrw
         DbParameter[] parameters = new DbParameter[] {
            DatabaseActions.MakeParameter("@CardNumber", card.CardNumber, DbType.String),
            DatabaseActions.MakeParameter("@Balance", card.Balance, DbType.Decimal),
            DatabaseActions.MakeParameter("@Holds", card.Holds, DbType.Decimal)
			};

         // uruchom okrelon instrukcj
         DatabaseActions.RunNonQuery(sql, parameters);
      }

      public override void Insert(CustomerCard card)
      {
         // do zrobienia
      }

      public override void Delete(CustomerCard card)
      {
         // do zrobienia
      }
   }
}