using System;
using System.Data;
using System.Collections.Generic;
using System.Web;

using FourLayer.BusinessEntity;
using FourLayer.DataAccessObject;

namespace FourLayer.ApplicationLogic
{
   public enum CustomerServiceCardErrors
   {
      NoError, CardCancelled, CardExpired, CardNotFound, InsufficientCredit, NameMismatch,
   }
   /// <summary>
   /// Obsuguje cao logiki aplikacji katalogu
   /// </summary>
   public class CustomerServiceLogic
   {
      /*
      * CustomerCard
      */
      public EntityCollection<CustomerCard> GetAllCards()
      {
         CustomerCardDAO dao = new CustomerCardDAO();
         return dao.GetAll();
      }
      public CustomerCard GetCardByNumber(string cardNumber)
      {
         if (cardNumber == null)
            return null;

         CustomerCardDAO dao = new CustomerCardDAO();
         return dao.GetByKey(cardNumber);
      }
      public CustomerServiceCardErrors Purchase(string cardNumber, string cardName, decimal amount)
      {
         // najpierw sprbuj pobra kart
         CustomerCard card = GetCardByNumber(cardNumber);
         if (card == null)
            return CustomerServiceCardErrors.CardNotFound;

         // sprawd, czy nazwa karty i numer s zgodne
         if (cardName != card.CardName)
            return CustomerServiceCardErrors.NameMismatch;

         // sprawd, czy karta zostaa anulowana
         if (card.IsCancelled)
            return CustomerServiceCardErrors.CardCancelled;

         // sprawd, czy karta wygasa
         if (card.IsExpired)
            return CustomerServiceCardErrors.CardExpired;

         // sprawd, czy nie przekroczono limitu kredytowego
         if (card.IsOverCreditLimit)
            return CustomerServiceCardErrors.InsufficientCredit;

         // wszystko w porzdku, a zatem sprbuj dokona zakupu
         CustomerCardErrors purchaseError = card.Purchase(amount);
         if (purchaseError == CustomerCardErrors.OverCreditLimit)
            return CustomerServiceCardErrors.InsufficientCredit;
         else
         {
            // zapisz dokonany zakup
            CustomerCardDAO dao = new CustomerCardDAO();
            dao.UpdateBalanceHold(card);
            return CustomerServiceCardErrors.NoError;
         }
      }
   }
}