using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using System.Data.OleDb;

public partial class UsingCommandBuilder : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
       // specifies database connection. Change this if needed
       string connString = "Provider=Microsoft.Jet.OLEDB.4.0;Data Source=";
       connString += Server.MapPath("~/App_Data/BookCatalogSystem.mdb") + ";";

       DataSet ds = new DataSet();

       try
       {
          // set up and open connection
         OleDbConnection conn = new OleDbConnection(connString);

         OleDbDataAdapter adapter = new OleDbDataAdapter();

         // set up select command
         string sqlSelect = " SELECT * FROM Authors";
         OleDbCommand cmdSelect = new OleDbCommand(sqlSelect, conn);
         adapter.SelectCommand = cmdSelect;

         OleDbCommandBuilder cb = new OleDbCommandBuilder(adapter);

         adapter.Fill(ds, "AuthorsTable");

         // modify some of the data in the DataTable

         // insert
         DataRow dr1 = ds.Tables["AuthorsTable"].NewRow();
         dr1["AuthorName"] = "Randy Connolly";
         ds.Tables["AuthorsTable"].Rows.Add(dr1);
         // update
         DataRow dr3 = ds.Tables["AuthorsTable"].Rows[0];
         dr3["AuthorName"] = "Ben Connolly";
         // delete
         //ds.Tables["AuthorsTable"].Rows[2].Delete();

         // now write the changes
         adapter.Update(ds, "AuthorsTable");

         // use filled DataSet
         grdAuthors.DataSource = ds.Tables["AuthorsTable"].DefaultView;
         grdAuthors.DataBind();
       }
       catch (Exception ex)
       {
          // process exception
          labMsg.Text = "Error occurred accessing the database";
          labMsg.Text += "<br/>" + ex.Message;
       }
    }
}
