using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using System.Data.OleDb;

public partial class UpdatingDataSet : System.Web.UI.Page
{
   protected void Page_Load(object sender, EventArgs e)
   {
      // specifies database connection. Change this if needed
      string connString = "Provider=Microsoft.Jet.OLEDB.4.0;Data Source=";
      connString += Server.MapPath("~/App_Data/BookCatalogSystem.mdb") + ";";

      DataSet ds = new DataSet();

      try
      {
         // set up and open connection
         OleDbConnection conn = new OleDbConnection(connString);

         OleDbDataAdapter adapter = new OleDbDataAdapter();

         // set up select command
         string sqlSelect = " SELECT * FROM Authors";
         OleDbCommand cmdSelect = new OleDbCommand(sqlSelect, conn);
         adapter.SelectCommand = cmdSelect;

         string sqlInsert = "INSERT INTO Authors (AuthorName)";
         sqlInsert += "VALUES (@name) ";

         // create the command object 
         OleDbCommand cmdInsert = new OleDbCommand(sqlInsert, conn);
         OleDbParameter param = new OleDbParameter("@name",OleDbType.VarChar);
         param.SourceColumn = "AuthorName";
         param.SourceVersion = DataRowVersion.Current;

         cmdInsert.Parameters.Add(param);
         adapter.InsertCommand = cmdInsert;

         adapter.Fill(ds, "AuthorsTable");

         // add some new rows to the DataTable
         DataRow dr1 = ds.Tables["AuthorsTable"].NewRow();
         dr1["AuthorName"] = "Randy Connolly";
         ds.Tables["AuthorsTable"].Rows.Add(dr1);

         DataRow dr2 = ds.Tables["AuthorsTable"].NewRow();
         dr2["AuthorName"] = "Alexander Connolly";
         ds.Tables["AuthorsTable"].Rows.Add(dr2);

         adapter.Update(ds, "AuthorsTable");

         // use filled DataSet
         grdAuthors.DataSource = ds.Tables["AuthorsTable"].DefaultView;
         grdAuthors.DataBind();
      }
      catch (Exception ex)
      {
         // process exception
         labMsg.Text = "Error occurred accessing the database";
         labMsg.Text += "<br/>" + ex.Message;
      }
   }
}
