using System;
using System.Data;
using System.Data.Common;


/// <summary>
/// 
/// </summary>
public class PublisherDA: AbstractDA
{

	protected override string SelectStatement
	{
		get { return "SELECT PublisherId, PublisherName FROM Publishers"; }
	}

	/// <summary>
	/// Returns a data table containing publisher table info for this id.
	/// Note that this data set will contain either 0 or 1 rows of data.
	/// </summary>
	public DataTable GetPublisherById(int id)
	{
		// set up parameterized query statement
		string sql = SelectStatement + " WHERE PublisherId=@id";

		// construct array of parameters
      DbParameter[] parameters = new DbParameter[] {
			MakeParameter("@id", id, DbType.Int32)
															};
		// return result
		return GetDataTable(sql, parameters);			
	}

}
