using System;

/// <summary>
/// Defines the base interface for any entity
/// </summary>
public abstract class AbstractEntity
{
   // data members
   private int _id;

   public AbstractEntity()
   {
      _id = 0;
   }
	public AbstractEntity(int id)
	{
      _id = id;
	}

   /// <summary>
   /// Every entity must have an id
   /// </summary>
   public int Id
   {
      get { return _id; }
      set { _id = value; }
   }

   /// <summary>
   /// Each entity will be responsible for determining the 
   /// validity of its own state
   /// </summary>
   public abstract bool IsValid
   {
      get;
   }
}
