using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class UsingDataTable : System.Web.UI.Page
{
   protected void Page_Load(object sender, EventArgs e)
   {
      DataTable table = new DataTable();

      DataColumn idCol = new DataColumn();
      idCol.ColumnName = "Id";
      idCol.DataType = typeof(Int32);
      idCol.AllowDBNull = false;
      idCol.Unique = true;
      idCol.AutoIncrement = true;

      DataColumn firstNameCol = new DataColumn("FirstName", typeof(string));
      DataColumn lastNameCol = new DataColumn("LastName", typeof(string));
      DataColumn phoneCol = new DataColumn("Phone", typeof(string));
      DataColumn nameCol = new DataColumn("FullName", typeof(string));
      nameCol.Expression = "LastName + ', ' + FirstName";

      table.Columns.Add(idCol);
      table.Columns.Add(firstNameCol);
      table.Columns.Add(lastNameCol);
      table.Columns.Add(phoneCol);
      table.Columns.Add(nameCol);

      DataRow r1 = table.NewRow();
      r1[1] = "Thomas";
      r1[2] = "Hobbes";
      r1[3] = "123-4567";
      table.Rows.Add(r1);

      DataRow r2 = table.NewRow();
      r2["FirstName"] = "David";
      r2["LastName"] = "Hume";
      r2["Phone"] = "564-7823";
      table.Rows.Add(r2);

      lboxTable.DataSource = table;
      lboxTable.DataBind();
   }
}
