using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

// nie naley zapomnie o dodaniu:
using System.IO;
using System.Xml;

public partial class ReadXML : System.Web.UI.Page
{
   protected void Page_Load(object sender, EventArgs e)
   {
      if (!IsPostBack)
      {
         panData.Visible = false;
         txtXML.Text = "App_Data/GameSystemsMenu.xml";
      }
   }

   /// <summary>
   /// Obsuga przycisku adowania
   /// </summary>
   protected void btnLoad_Click(object sender, EventArgs e)
   {
      panData.Visible = true;
      string path = "";
      labMsg.Text = "";
      try
      {
         DataSet ds1 = new DataSet();
         path = txtXML.Text;         

         // jeeli dane uytkownika nie zaczynaj sie od http, zakadamy, e jest to plik lokalny
         if (!path.StartsWith("http", StringComparison.CurrentCultureIgnoreCase))
            path = Server.MapPath(path);
         
         // utworzenie obbiektu odczytu danych i zaadowanie do DataSet
         XmlTextReader xtr = new XmlTextReader(path);
         ds1.ReadXml(xtr, XmlReadMode.InferSchema);

         // przegldanie kadego obiektu DataTable i wywietlanie zawartoci
         foreach (DataTable table in ds1.Tables)
         {
            // dynamiczne tworzenie nazwy tabeli
            Literal caption = new Literal();
            caption.Text = "<h2>Tabela: " + table.TableName + "</h2>";
            phData.Controls.Add(caption);
            // dynamiczne tworzenie widoku tabularycznego
            GridView grid = new GridView();
            // konfigurowanie wygldu i dodanie do DataTable
            grid.CellPadding = 3;
            grid.DataSource = table.DefaultView;
            grid.DataBind();
            // dodanie obiektu GridView do PlaceHolder
            phData.Controls.Add(grid);
         }
      }
      catch (IOException)
      {
         panData.Visible = false;
         labMsg.Text = "Nie znaleziono: " + txtXML.Text;
      }
      catch
      {
         panData.Visible = false;
         labMsg.Text = "Nie mona uzyska dostpu do :" + path;
      }
   }
}
