using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class DataViewTester : System.Web.UI.Page
{

protected void Page_Load(object sender, EventArgs e)
{
   if (!IsPostBack)
      grdCustomer.Visible = false;
}

/// <summary>
/// HProcedura obsugi przycisku Podgld danych
/// </summary>
protected void btnViewData_Click(object sender, EventArgs e)
{
   // utworzenie wypenionego obiektu DataTable
   DataTable table = MakeData();

   // utworzenie nowego widoku
   DataView view = new DataView(table); 
   // ustawienie sortowania i filtrowania widoku
   view.Sort = drpSort.SelectedValue + " ASC";
   if (txtFilter.Text.Length > 0)
      view.RowFilter = "LastName Like '" + txtFilter.Text + "'";

   // doczenie widoku do GridView
   grdCustomer.Visible = true;
   grdCustomer.DataSource = view;
   grdCustomer.DataBind();
}

/// <summary>
/// Tworzy i zwraca wypeniony obiekt DataTable
/// </summary>
private DataTable MakeData()
{
   DataTable table = new DataTable();

   DataColumn idCol = new DataColumn();
   idCol.ColumnName = "Id";
   idCol.DataType = typeof(Int32);
   idCol.AllowDBNull = false;
   idCol.Unique = true;
   idCol.AutoIncrement = true;

   DataColumn firstNameCol = new DataColumn("FirstName", typeof(string));
   DataColumn lastNameCol = new DataColumn("LastName", typeof(string));
   DataColumn phoneCol = new DataColumn("Phone", typeof(string));

   table.Columns.Add(idCol);
   table.Columns.Add(firstNameCol);
   table.Columns.Add(lastNameCol);
   table.Columns.Add(phoneCol);

   DataRow r1 = table.NewRow();
   r1[1] = "Tomasz";
   r1[2] = "Halicki";
   r1[3] = "123-4567";
   table.Rows.Add(r1);

   DataRow r2 = table.NewRow();
   r2["FirstName"] = "Dawid";
   r2["LastName"] = "Murek";
   r2["Phone"] = "564-7823";
   table.Rows.Add(r2);

   DataRow r3 = table.NewRow();
   r3["FirstName"] = "Martin";
   r3["LastName"] = "Tajemniczy";
   r3["Phone"] = "253-6383";
   table.Rows.Add(r3);

   DataRow r4 = table.NewRow();
   r4["FirstName"] = "Jacek";
   r4["LastName"] = "Rusek";
   r4["Phone"] = "456-1267";
   table.Rows.Add(r4);

   return table;
}
}
