using System;
using System.Data;
using System.IO;
using System.Configuration;
using System.Collections;
using System.Collections.Specialized;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class DynamicTheme : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
		// dynamically load the drop down list
		if (!IsPostBack)
		{
			string path = Server.MapPath("~/App_Themes");
			if (Directory.Exists(path))
			{
				string[] folders = Directory.GetDirectories(path);
				foreach (string folder in folders)
				{
					DirectoryInfo info = new DirectoryInfo(folder);
					drpThemes.Items.Add(info.Name);
				}
			}
		}
    }

	protected void Page_PreInit(object sender, EventArgs e)
	{
		string themeName = Request.Form["drpThemes"];
		if (themeName != null)
		{
			this.Page.Theme = themeName;
		}
	}
}
