using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using System.IO;

public partial class BookWithThemes : System.Web.UI.MasterPage
{
   /// <summary>
   /// W czasie adowania wypenienie listy tematw na podstawie zawartoci folderu App_Themes
   /// </summary>
   protected void Page_Load(object sender, EventArgs e)
   {
      // dynamiczne adowanie listy rozwijanej tylko za perwszym razem
      if (!IsPostBack)
      {
         // tematy musz znajdowa si w tej lokalizacji
         string path = Server.MapPath("~/App_Themes");
         // sprawdzenie, czy lokalizacja istnieje
         if (Directory.Exists(path))
         {
            // odczyt tablicy nazw folderw tematw
            String[] themeFolders = Directory.GetDirectories(path);
            // przetwarzanie elementw tej tablicy
            foreach (String folder in themeFolders)
            {
               // pobieranie informacji na temat nazw folderw
               DirectoryInfo info = new DirectoryInfo(folder);
               // dodanie nazwy folderu do listy rozwijanej
               drpThemes.Items.Add(info.Name);
            }
            // po dodaniu wszystkich tematw do listy, naley ustawi 
            // biecy temat strony w licie

            // na pocztek wyszukujemy nazw tematu strony w licie
            ListItem item = drpThemes.Items.FindByText(Page.Theme);
            // nastpnie ustawiamy wybrany indeks w licie (czyli wybieramy
            // element listy) na znaleziony elementlisty
            drpThemes.SelectedIndex = drpThemes.Items.IndexOf(item);
         }
      }
   }

   /// <summary>
   /// Procedura obsugi zdarzenia wyboru tematu
   /// </summary>
   protected void drpTheme_selectedChanged(object s, EventArgs e)
   {
      //zapisanie tematu w sesji
      string theme = drpThemes.SelectedItem.Text;
      Session["themeName"] = theme;

      //ponowne danie strony
      string page = Request.Path;
      Server.Transfer(page);
   }

   /// <summary>
   /// Waciwo pozwalajca ustawi i odczyta url strony z reklam
   /// </summary>
   public string AdImageUrl
   {
      get { return imgbtnAd.ImageUrl; }
      set { imgbtnAd.ImageUrl = value; }
   }

   /// <summary>
   /// Waciwo pozwalajca ustawi i odczyta url 
   /// cza obrazu reklamowego.
   /// </summary>
   public string AdNavigateUrl
   {
      get { return imgbtnAd.NavigateUrl; }
      set { imgbtnAd.NavigateUrl = value; }
   }
}
