using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

// need to add these
using System.Net;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;

public partial class ScrapeHeadings : System.Web.UI.Page
{
   /// <summary>
   /// Przy kadym zaadowaniu strony skasowa zawarto kontrolki Literal
   /// </summary>
   protected void Page_Load(object sender, EventArgs e)
   {
     litContent.Text = "";
   }

   /// <summary>
   /// Procedura obsugi przycisku wyszukiwania
   /// </summary>
   protected void btnSearch_Click(object sender, EventArgs e)
   {
      // Naley przechwyci bdy nie odpowiadajcych adresw URL
      try
      {
         // uycie klasy WebClient do pobrania zawartoci adresu URL
         WebClient client = new WebClient();
         string content = client.DownloadString(txtUrl.Text);

         // Dopasowanie wszystkich znacznikw H?
         Regex reg = new Regex(@"<h\d.+</h\d>", RegexOptions.IgnoreCase);

         // pobranie kolekcji wszystkich dopasowa
         MatchCollection mc = reg.Matches(content);

         // przegldanie kolekcji dopasowa
         foreach (Match m in mc)
         {
            // kodowanie znacznikw i wywietlanie w literale
            litContent.Text += HttpUtility.HtmlEncode(m.Value) + "<br/>";
         }
      }
      catch
      {
         litContent.Text = "Nie mona si podczy do " + txtUrl.Text;
      }      
   }
}
