<%@ Page Language="C#" AutoEventWireup="true" CodeFile="GroupingValidators.aspx.cs" Inherits="GroupingValidators"  %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" >
<head runat="server">
    <title>Uycie grup kontroli poprawnoci</title>
    <style type="text/css">
      body { font-size: 76%; font-family: Verdana, Arial, sans-serif;}
      #panHeader h1 { font-size: 120%;  padding-bottom: 4px; margin-bottom: 1px; border-bottom: 1px solid #999; }
      #panHeader p { margin-top: 1px; }
      #panContent { float: left; width: 68%; background: white; margin-right: 2%; }
      #panSidebar { float: right;  width: 30%; background: beige;  }
      #panSidebar div { padding: 10px; align: left;}
      #panContent p { margin: 6px 0; }
    </style>
</head>
<body>
    <form id="form1" runat="server">
    <div id="wrap">
    
      <asp:Panel ID="panHeader" runat="server">
         <h1>Przykad zastosowania grup kontroli poprawnoci</h1>
         <p>Na tej stronie zastosowane s dwie osobne grupy kontroli poprawnoci oraz kontrolki sprawdzajce poprawno przedstawione w tym rozdziale.</p>
      </asp:Panel>
      
      <%-- Gwny panel recenzji ksiki --%>
      <asp:Panel ID="panContent" runat="server" GroupingText="Recenzja ksiki">
         <p>
         <asp:Label ID="labDate" runat="server" Text="Data recenzji" AccessKey="D" AssociatedControlID="txtDate" />
         <br />
         <asp:TextBox ID="txtDate" runat="server"></asp:TextBox>
         <asp:CustomValidator ID="custDate" runat="server" 
            ControlToValidate="txtDate" 
            ValidateEmptyText="true"  
            ValidationGroup="main"
            Text="*"
            ErrorMessage="Prosz poda prawidow dat z przyszoci" 
            OnServerValidate="custDate_ServerValidate" />   
         </p> 
               
         <p>
         <asp:Label ID="labBook" runat="server" Text="Ksika do recenzji" AccessKey="B" AssociatedControlID="lstBooks" />
         <br />
         <asp:DropDownList ID="lstBooks" runat="server" AccessKey="K" >
            <asp:ListItem Value="0" Selected="True">Prosz wybra ksik</asp:ListItem>
            <asp:ListItem Value="1">Republika</asp:ListItem>
            <asp:ListItem Value="2">Krytyka rozsdku</asp:ListItem>
            <asp:ListItem Value="3">Teoria sprawiedliwoci</asp:ListItem>
         </asp:DropDownList>
         <asp:RequiredFieldValidator ID="reqBook" runat="server" 
            ControlToValidate="lstBooks" SetFocusOnError="true"
            ValidationGroup="main"
            Text="*"
            InitialValue="0" 
            ErrorMessage="Prosz wybra ksizk z listy"/>      
         </p>
         
         <p>
         <asp:Label ID="labRating" runat="server" Text="Ocena od 1 do 5" AccessKey="O" AssociatedControlID="txtDate" />
         <br />
         <asp:TextBox ID="txtRating" runat="server" Columns="10" AccessKey="D"/>
         <asp:RangeValidator ID="rangeNum" runat="server" 
            ControlToValidate="txtRating" 
            MinimumValue="1"
            MaximumValue="5"
            Type="Integer"
            ValidationGroup="main"
            Text="Prosz poda liczb od 1 do 5" />                
         </p>
         
         <p>
         <asp:Label ID="labUser" runat="server" Text="Nazwa uytkownika" AccessKey="U" AssociatedControlID="txtUserName"  />
         <br />
         <asp:TextBox ID="txtUserName" runat="server" Columns="10" AccessKey="U" />
         <asp:RequiredFieldValidator ID="reqUserName" runat="server" 
            ControlToValidate="txtUserName"
            ValidationGroup="main"
            Text="*"
            ErrorMessage="Prosz poda nazw uytkownika"/>
         <asp:RegularExpressionValidator ID="regName" runat="server" 
            ControlToValidate="txtUserName" 
            ValidationExpression="^[a-zA-Z'.\s]{1,16}"
            Text="Prosz poda prawidow nazw uytkownika" />
            
         </p>
                  
         <p>
         <asp:Label ID="labPass1" runat="server" Text="Haso" AccessKey="H" AssociatedControlID="txtPass1" />
         <br />
         <asp:TextBox ID="txtPass1" runat="server" TextMode="password" Columns="10" AccessKey="H"/>
         <asp:RequiredFieldValidator ID="reqPassword" runat="server" 
            ControlToValidate="txtPass1"  SetFocusOnError="true"
            ValidationGroup="main"
            Text="*"
            Display="static" 
            ErrorMessage="Prosz poda haso"/>
         <asp:RegularExpressionValidator ID="regPass1" runat="server" 
            ControlToValidate="txtPass1"  
            ValidationExpression="^[a-zA-Z]\w{8,}$"
            ValidationGroup="main"
            Text="*"
            ErrorMessage="Haso musi mie co najmniej 8 znakw" />   
         <asp:RegularExpressionValidator ID="regPass2" runat="server" 
            ControlToValidate="txtPass1"  
            ValidationExpression="^[a-zA-Z]+\w*\d+\w*$"
            ValidationGroup="main"
            Text="*"
            ErrorMessage="Haso musi zaczyna si od litery i zawiera cyfr" />  
         </p>                    
         <p>
         <asp:Label ID="labPass2" runat="server" Text="Powtrz haso" AccessKey="P" AssociatedControlID="txtPass2" />
         <br />
         <asp:TextBox ID="txtPass2" runat="server" TextMode="password" Columns="10" AccessKey="P"/>
         <asp:CompareValidator ID="compPass" runat="server" 
            ControlToValidate="txtPass2" 
            Operator="Equal"
            ControlToCompare="txtPass1"
            ValidationGroup="main"
            Text="*"
            ErrorMessage="Hasa musz by identyczne" /> 
         </p>                 
         
         <p>
         <asp:ValidationSummary id="valSum" runat="server" 	
            ValidationGroup="main" BorderStyle="Dashed" BorderWidth="1" BorderColor="red"
		      DisplayMode="BulletList"
		      HeaderText="Znaleziono nastpujce bdy:"
		      ShowMessageBox="false" 
		      ShowSummary="true" />
         </p>
         
         <p>
         <asp:Button ID="btnSubmit" runat="server"
            ValidationGroup="main" 
            Text="Wylij" OnClick="btnSubmit_Click"  />
         </p>
      </asp:Panel>
      
      <%-- Panel paska wyszukiwania --%>
      <asp:Panel ID="panSidebar" runat="server" GroupingText="Search">
         <div>
         <asp:Label ID="labSearch" runat="server" Text="Szukaj" AccessKey="S" AssociatedControlID="txtSearch" />
         <br />
         <asp:TextBox ID="txtSearch" runat="server" Columns="10"/>
         <asp:Button ID="btnSearch" runat="server" 
            Text="Szukaj" 
            ValidationGroup="search" 
            OnClick="btnSearch_Click"/><br />
         <asp:RequiredFieldValidator ID="reqSearch" runat="server" 
            ControlToValidate="txtSearch"
            SetFocusOnError="true"
            ValidationGroup="search"
            Text="Prosz poda cig wyszukiwania"
            Display="Dynamic" />

         </div>
      </asp:Panel>

    </div>
    </form>
</body>
</html>
