using System;
using System.Data;
using System.Data.Common;
using System.Collections.Generic;

using FourLayer.BusinessEntity;

namespace FourLayer.DataAccessObject
{

   /// <summary>
   /// Summary description for PublisherDAO
   /// </summary>
   public class PublisherDAO: AbstractDAO<Publisher> 
   {
      public PublisherDAO()
      {
      }

      protected override string SelectStatement
      {
         get { return "SELECT PublisherId,PublisherName,PublisherWebSite,PublisherRSS  FROM Publishers"; }
      }
      protected override string PrimaryKeyName
      {
         get { return "PublisherId"; }
      }
      public override bool IsGetAllCached
      {
         get { return true; }
      }
      public override string CacheName
      {
         get { return "Publishers"; }
      }

      protected override Publisher CreateAndFillEntity(DbDataReader recordJustRead)
      {
         // grab the record values and put them into temporary variables
         //int id = recordJustRead.GetInt32(0);
         //string name = recordJustRead.GetString(1);

         int id = (int)recordJustRead["PublisherId"];
         string name = (string)recordJustRead["PublisherName"];
         string homeUrl = (string)recordJustRead["PublisherWebSite"];
         string rssUrl = (string)recordJustRead["PublisherRSS"];

         // build and populate object from the data
         Publisher pub = new Publisher(id, name,homeUrl,rssUrl);
         return pub;
      }

      public override DataTable AdaptCollectionToDataTable(EntityCollection<Publisher> collection)
      {
         DataTable dt = new DataTable();
         dt.Columns.Add(new DataColumn("Id", Type.GetType("System.Int32")));
         dt.Columns.Add(new DataColumn("Name", Type.GetType("System.String")));
         dt.Columns.Add(new DataColumn("WebSite", Type.GetType("System.String")));
         dt.Columns.Add(new DataColumn("Rss", Type.GetType("System.String")));

         foreach (Publisher p in collection)
         {
            DataRow dr = dt.NewRow();
            dr[0] = p.Id;
            dr[1] = p.Name;
            dr[2] = p.HomePageUrl;
            dr[3] = p.RssUrl;
            dt.Rows.Add(dr);
         }
         return dt;
      }

      public override void Update(Publisher publisher)
      {
         string sql = "UPDATE Publishers SET PublisherName=@PublisherName,PublisherWebSite=@PublisherWebSite,PublisherRSS=@PublisherRSS";
         sql += " WHERE PublisherId=@PublisherId";

         // construct array of parameters
         DbParameter[] parameters = new DbParameter[] {
            DatabaseActions.MakeParameter("@PublisherId", publisher.Id, DbType.Int32),
            DatabaseActions.MakeParameter("@PublisherName", publisher.Name, DbType.String),
            DatabaseActions.MakeParameter("@PublisherWebSite", publisher.HomePageUrl, DbType.String),
            DatabaseActions.MakeParameter("@PublisherRSS", publisher.RssUrl, DbType.String)
			};

         // run the specified command
         DatabaseActions.RunNonQuery(sql, parameters);
      }

      public override void Insert(Publisher publisher)
      {
         string sql = "INSERT INTO Publishers (PublisherName,PublisherWebSite,PublisherRSS) ";
         sql += " VALUES (@PublisherName,@PublisherWebSite,@PublisherRSS)";

         // construct array of parameters
         DbParameter[] parameters = new DbParameter[] {
            DatabaseActions.MakeParameter("@PublisherName", publisher.Name, DbType.String),
            DatabaseActions.MakeParameter("@PublisherWebSite", publisher.HomePageUrl, DbType.String),
            DatabaseActions.MakeParameter("@PublisherRSS", publisher.RssUrl, DbType.String)
			};

         // run the specified command
         DatabaseActions.RunNonQuery(sql, parameters);
      }

      public override void Delete(Publisher publisher)
      {
         string sql = "DELETE FROM Publishers WHERE PublisherId=@PublisherId";

         // construct array of parameters
         DbParameter[] parameters = new DbParameter[] {
            DatabaseActions.MakeParameter("@PublisherId", publisher.Id, DbType.Int32)
			};

         // run the specified command
         DatabaseActions.RunNonQuery(sql, parameters);
      }
   }
}