using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using System.Xml;
using System.Xml.XPath;
using System.Xml.Xsl;

public partial class RSSControl : CustomWebPartBase
{
   private string _xmlUrl = "~/amazonRSS.xml";
   private string _xsltUrl = "~/RssTransform2.xsl";

   public RSSControl() : base()
   {
      Description = "Wywietla kana RSS";
      _subtitle = "Kana RSS";
   }

   protected override string IconFileName
   {
      get { return "images/webpartRSS.gif"; }
   }

   protected void Page_Load(object sender, EventArgs e)
   {
      // utwrz obiekt klasy XPathNavigator
      string xmlurl = Server.MapPath(XmlUrl);
      XPathDocument xpdoc = new XPathDocument(xmlurl);
      XPathNavigator xnav = xpdoc.CreateNavigator();

      // skonfiguruj kontrolk xml
      myXml.XPathNavigator = xnav;
      myXml.TransformSource = Server.MapPath(XsltUrl);
   }

   public string XmlUrl
   {
      get { return _xmlUrl; }
      set { _xmlUrl = value; }
   }
   public string XsltUrl
   {
      get { return _xsltUrl; }
      set { _xsltUrl = value; }
   }
}
