<%@ Application Language="C#" %>

<script runat="server">



   public void Profile_OnMigrateAnonymous(object sender, ProfileMigrateEventArgs args)
   {
      // pobierz profil anonimowy
      ProfileCommon anonymousProfile = Profile.GetProfile(args.AnonymousID);
      
      // przenie wartoci tylko wtedy, gdy nie zostay jeszcze przeniesione
      if (!Profile.MigratedAlready)
      {

         // przekopiuj profil anonimowy do profilu zalogowanego
         Profile.Theme = anonymousProfile.Theme;
         Profile.WishList = anonymousProfile.WishList;
         Profile.Last5Products = anonymousProfile.Last5Products;         
      }

      // poniewa uytkownik jest obecnie zalogowany, naley upewni si, 
      // e jego profil nie zostanie w przyszoci nadpisany za pomoc przeczenia flagi MigratedAlready
      Profile.MigratedAlready = true;

      // Usu profil anonimowy. Jeli identyfikator anonimowy nie jest potrzebny
      // na pozostaych stronach witryny, usu anonimowe ciasteczko.
      ProfileManager.DeleteProfile(args.AnonymousID);
      AnonymousIdentificationModule.ClearAnonymousIdentifier();
   }

   
       
</script>
