using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class ChangeDisplayMode : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
       if (!IsPostBack)
       {
          // przejd przez wszystkie obsugiwane tryby wywietlania
          foreach (WebPartDisplayMode mode in
             partManager.SupportedDisplayModes)
          {
             // poka tryb wywietlania tylko wtedy, gdy jest dostpny dla biecego uytkownika
             if (mode.IsEnabled(partManager))
             {
                // utwrz element listy i dodaj go do niej
                ListItem item = new ListItem(mode.Name);

                // jeli ten element jest zgodny z biecym trybem wywietlania,
                // oznacz go jako element wybrany
                if (mode == partManager.DisplayMode)
                   item.Selected = true;

                drpWebPartMode.Items.Add(item);
             }
          }
       }
    }

   protected void drpWebPartMode_SelectedIndexChanged(object sender,
      EventArgs e)
   {
      // pobierz wybr uytkownika
      string mode = drpWebPartMode.SelectedValue;

      // pobierz odpowiedni dla tego trybu obiekt klasy WebPartDisplayMode
      WebPartDisplayMode display = partManager.SupportedDisplayModes[mode];

      // przecz tryb wywietlania, jeli jest on dostpny
      if (display != null && display.IsEnabled(partManager))
         partManager.DisplayMode = display;
   }

}
