<%@ Page Language="C#" AutoEventWireup="true" Theme="WebPartDemo"
   CodeFile="CatalogTest.aspx.cs" Inherits="CatalogTest" %>

<%@ Register Src="controls/CustomersControl.ascx" TagName="CustomersControl" TagPrefix="uc" %>
<%@ Register Src="controls/SearchControl.ascx" TagName="SearchControl" TagPrefix="uc" %>
<%@ Register Src="controls/RecentViewsPartControl.ascx" TagName="RecentViewsPartControl"
   TagPrefix="uc" %>
<%@ Register Src="controls/CalendarControl.ascx" TagName="CalendarControl" TagPrefix="uc" %>   
<%@ Register Src="controls/RSSControl.ascx" TagName="RSSControl" TagPrefix="uc" %>
<%@ Register Src="controls/RecentBooksControl.ascx" TagName="RecentBooksControl"
   TagPrefix="uc" %>
<%@ Register Src="controls/MainMenuControl.ascx" TagName="MainMenuControl" TagPrefix="uc" %>
<%@ Register Src="controls/LoginControl.ascx" TagName="LoginControl" TagPrefix="uc" %>

<%@ Register Namespace="Chapter14" TagPrefix="ch14" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
   <title>Testowanie katalogu</title>
   <link href="chapterStyles.css" type="text/css" rel="stylesheet"  />
</head>
<body id="body1" runat="server" >
   <form id="form1" runat="server">
      <asp:WebPartManager ID="partManager" runat="server" />
      <div id="container">
         <div id="header">
            <div id="theme">
               Web Part Mode:
               <asp:DropDownList ID="drpWebPartMode" runat="server" 
                  AutoPostBack="true"
                  OnSelectedIndexChanged="drpWebPartMode_SelectedIndexChanged" />
            </div>
            
            <div id="logo">
               <asp:Image runat="server" ID="imgLogo" SkinID="logo" />
            </div>
         </div>
         <div id="sideArea">
            <asp:CatalogZone ID="catZone" runat="server" Padding="6" HeaderText="Strefa katalogu" SelectTargetZoneText="Dodaj do:" InstructionText="Wybierz katalog, ktry chcesz przeglda." EmptyZoneText="Strefa katalogu nie zawiera skadnikw katalogu." AddVerb-Text="Add" CloseVerb-Text="Close" HeaderCloseVerb-Text="Zamknij">
               <ZoneTemplate>
                  <asp:PageCatalogPart ID="pageCatalog" runat="server" Title="Katalog strony" />
                  <asp:DeclarativeCatalogPart ID="decCatalog" runat="server" 
                        Title="Skadniki opcjonalne">
                     <WebPartsTemplate>
                        <uc:CalendarControl ID="myCalendar" runat="server" 
                           Title="Kalendarz"/>
                        <uc:RecentViewsPartControl ID="myRecentViews" runat="server" 
                           Title="Ostatnio przegldane produkty"/>
                     </WebPartsTemplate>
                  </asp:DeclarativeCatalogPart>
               </ZoneTemplate>
            </asp:CatalogZone> 
         
            <asp:WebPartZone ID="zoneSide" runat="server" 
                  Padding="6" WebPartVerbRenderMode="TitleBar"
                  PartChromeType="TitleOnly"  Width="14em" CloseVerb-Text="Zamknij" ConnectVerb-Text="Pocz" DeleteVerb-Text="Usu" EditVerb-Text="Edytuj" RestoreVerb-Text="Przywr" MinimizeVerb-Text="Minimalizuj">
               <ZoneTemplate>
                  <uc:MainMenuControl ID="myMenu" runat="server" Title="Menu"/>      
                  <uc:LoginControl ID="myLogin" runat="server" 
                     Title="Biecy uytkownik" />           
                  <uc:SearchControl ID="mySearch" runat="server" 
                     Title="Szukanie"/>           
                  <uc:CustomersControl ID="myCustomers" runat="server" 
                     Title="Moi klienci" />
               </ZoneTemplate> 
            </asp:WebPartZone>    
         </div>
         <div id="mainArea">
            <asp:EditorZone ID="editZone" runat="server" Width="300px">
               <ZoneTemplate>
                  <asp:PropertyGridEditorPart ID="partProp" runat="server" />
               </ZoneTemplate>
            </asp:EditorZone>    
            <asp:WebPartZone ID="zoneMain" runat="server" 
                  WebPartVerbRenderMode="Menu"               
                  Padding="6" PartChromeType="TitleOnly">
               <ZoneTemplate>
                  <uc:RecentBooksControl ID="RecentBooksControl1" runat="server" 
                     Title="Najnowsze ksiki" />
                  <uc:RSSControl ID="RSSControl1" runat="server"
                     Title="Najlepiej sprzedawane ksiki informatyczne w Amazonie"
                     Description="Najlepiej sprzedawane ksiki informatyczne w Amazonie"                      
                     XmlUrl="~/amazonRSS.xml" 
                     XsltUrl="~/RssTransformAmazon.xsl" />
                  <uc:RSSControl ID="myPearson" runat="server"
                     Title="Nowoci wydawnictwa Pearson"
                     Description="Nowoci wydawnictwa Pearson" 
                     CatalogIconImageUrl="~/images/webpartNews.gif"
                     TitleIconImageUrl="~/images/webpartNews.gif"
                     XmlUrl="~/pearsonRSS.xml" 
                     XsltUrl="~/RssTransformPearson.xsl" />   
               </ZoneTemplate>
            </asp:WebPartZone>
         </div>
         <div id="footer">
            <p>
               Ta strona nie jest prawdziwa. Jest jedynie przykadem z ksiki o ASP.NET wydawnictwa Helion.</p>
         </div>
      </div>

      <asp:Label ID="labMsg" runat="Server" />
   </form>
</body>
</html>
