using System;
using System.Collections;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;

using FourLayer.ApplicationLogic;
using FourLayer.BusinessEntity;

namespace Chapter14
{
   /// <summary>
   /// Cz konsumenta
   /// </summary>
   public class BookListConsumer : WebPart
   {
      private Publisher _publisher = null;

      public BookListConsumer()
      {
         Title = "Poka ksiki";
         Description = "Poka wszystkie ksiki";
         TitleIconImageUrl = "images/webpartBooks.gif";
         CatalogIconImageUrl = "images/webpartBooks.gif";         
      }

      public Publisher PublisherToUse
      {
         get { return _publisher; }
         set { 
            _publisher = value;
            Title = "Poka ksiki wydawnictwa " + _publisher.Name;
         }
      }

      protected override void RenderContents(HtmlTextWriter writer)
      {
         // pobierz zbir ksiek wybranego wydawcy
         EntityCollection<Book> books =
            BookCatalogLogic.GetBooksByPublisher(PublisherToUse.Id);

         // wywietl nie wicej ni 10 pierwszych ksiek
         int max = 10;
         if (max > books.Count) max = books.Count;
         string output = "<div id='listContainer'>";
         for (int i = 0; i < max; i++)
         {
            Book book = books[i];
            output += "<p><a href=BookDetails.aspx?id=";
            output += book.Isbn + ">";
            output += book.Title;
            output += "></p>";
         }
         output += "</div>";
         writer.Write(output);
      }


      private ISelectPublisher _pubInterface;

      /// <summary>
      /// Definiuje punkt poczenia
      /// </summary>
      [ConnectionConsumer("SelectedPublisherConnectionPoint")]
      public void GetProvider(ISelectPublisher pubInterface)
      {
         _pubInterface = pubInterface;
      }

      /// <summary>
      /// Pobiera wydawc od dostawcy
      /// </summary>
      protected override void OnPreRender(EventArgs e)
      {
         if (_pubInterface != null)
         {
            PublisherToUse = _pubInterface.ChosenPublisher;
         }
      }

   }
}
