<%@ Page Language="C#" AutoEventWireup="true" CodeFile="TestApplicationLogic.aspx.cs" Inherits="TestApplicationLogic" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
	<title>Testowanie klasy BookCatalogLogic</title>
	<link href="chapterStyles.css" type="text/css" rel="stylesheet" />
	<style type="text/css">
		.dataValues { font-weight: bold; }
		.singleBook { border-top: 1pt solid #E7E7E7;
		              border-left: 1pt solid #E7E7E7;
		              border-bottom: 1pt solid #D2D2D2;
		              border-right: 1pt solid #D2D2D2;
		              padding: 1em;	
		              margin: 1em;              
		              background: #FFFFE0;		              
		               }
		 .singleBookTitle {
                    vertical-align: middle;
                    text-align: center;
		              background: #FFFFCC;
		              }
		  .entireForm {
		            border: 2pt solid #D7D7D7; 
		  }
		  .actionBar { background: #FFFFCC; margin-top: 0.5em; padding: 0.5em; border: 1pt solid #E7E7E7;}
		  .entity { margin: 0.5em; border: solid 1pt black; padding: 0.5em; }
	</style>
</head>
<body>
	<form id="form1" runat="server">
		<div id="container">
			<h1>Testowanie klasy BookCatalogLogic</h1>
			<p>
			Aplikacja testuje klas <code>BookCatalogLogic</code>.
			</p>
         <div class="entity">
<h2>Books</h2>
         <asp:GridView ID="grdBooks" runat="server" DataSourceID="dsBookCatBook" 
               CssClass="entireForm" AllowPaging="true" PageSize="5" 
               DataKeyNames="Isbn" AllowSorting="true"
               AutoGenerateColumns="false"
               AutoGenerateSelectButton="true"
               AutoGenerateEditButton="true" 
               AutoGenerateDeleteButton="true">

            <Columns>
               <asp:BoundField DataField="Isbn" HeaderText="Id" ReadOnly="true" SortExpression="Isbn"/>
               <asp:BoundField DataField="Title" HeaderText="Tytu" SortExpression="Title"/>   
               <asp:BoundField DataField="YearPublished" HeaderText="Rok" SortExpression="YearPublished"/>  

               <asp:TemplateField HeaderText="Opis">
                  
                  <ItemTemplate> 
                     <%# Eval("BriefDescription")%>
                  </ItemTemplate>

                  <EditItemTemplate>
                     <asp:TextBox ID="txtDescription" runat="server" Rows="2" TextMode="MultiLine"
                        Text='<%# Bind("BriefDescription") %>'></asp:TextBox>
                  </EditItemTemplate>
               </asp:TemplateField>
                              
               <asp:TemplateField HeaderText="Wydawca" SortExpression="PublisherName">
                  
                  <ItemTemplate> 
                     <%# Eval("PublisherName")%>
                  </ItemTemplate>

                  <EditItemTemplate>
                     <asp:DropDownList ID="drpPublisher" runat="server" 
                       DataSourceID="dsBookCatPublisher" DataValueField="Id"
                       DataTextField="Name" 
                       SelectedValue='<%# Bind("PublisherId") %>' />
                  </EditItemTemplate>
               </asp:TemplateField>
                              
               <asp:TemplateField HeaderText="Seria" SortExpression="SeriesName">
                  
                  <ItemTemplate> 
                     <%# Eval("SeriesName")%>
                  </ItemTemplate>

                  <EditItemTemplate>
                     <asp:DropDownList ID="drpSeries" runat="server" 
                       DataSourceID="dsBookCatSeries" DataValueField="Id"
                       DataTextField="Name" 
                       SelectedValue='<%# Bind("SeriesId") %>' />
                  </EditItemTemplate>
               </asp:TemplateField>

               <asp:TemplateField HeaderText="Kategoria" SortExpression="CategoryName">
                  
                  <ItemTemplate> 
                     <%# Eval("CategoryName")%>
                  </ItemTemplate>

                  <EditItemTemplate>
                     <asp:DropDownList ID="drpCategory" runat="server" 
                       DataSourceID="dsBookCatCategories" DataValueField="Id"
                       DataTextField="Name" 
                       SelectedValue='<%# Bind("CategoryId") %>' />
                  </EditItemTemplate>
               </asp:TemplateField>               
            </Columns>
            
            <HeaderStyle CssClass="singleBookTitle" />            
            <PagerStyle CssClass="singleBookTitle" />
            <PagerSettings Mode="Numeric" />
         </asp:GridView>
         <p></p>			
		   <asp:DetailsView ID="dvBooksOne" runat="server" DataSourceID="dsBookCatBookOne" 
               CssClass="entireForm" AllowPaging="false" DataKeyNames="Isbn"
               AutoGenerateRows="false"  >
            <Fields>
               <asp:BoundField DataField="Title" HeaderText="Tytu" />     
            </Fields>            
            <HeaderStyle CssClass="singleBookTitle" /> 
         </asp:DetailsView>
         <p></p>	
         <asp:DetailsView ID="dvBooksNew" runat="server" DataSourceID="dsBookCatBook" 
               CssClass="entireForm" AllowPaging="false" DataKeyNames="Isbn"
               AutoGenerateRows="false"
               AutoGenerateInsertButton="true"
               DefaultMode="Insert"
               >

            <Fields>
               <asp:BoundField DataField="Isbn" HeaderText="Isbn" />    
               <asp:BoundField DataField="Title" HeaderText="Tytu" SortExpression="Name"/>   
               <asp:BoundField DataField="YearPublished" HeaderText="Rok" SortExpression="YearPublished"/>  
               <asp:BoundField DataField="BriefDescription" HeaderText="Opis" /> 
               <asp:TemplateField HeaderText="Wydawca">
                  <InsertItemTemplate>
                     <asp:DropDownList ID="drpPublisher" runat="server" 
                       DataSourceID="dsBookCatPublisher" DataValueField="Id"
                       DataTextField="Name" 
                       SelectedValue='<%# Bind("PublisherId") %>' />
                  </InsertItemTemplate>
               </asp:TemplateField>
                              
               <asp:TemplateField HeaderText="Seria">
                  <InsertItemTemplate>
                     <asp:DropDownList ID="drpSeries" runat="server" 
                       DataSourceID="dsBookCatSeries" DataValueField="Id"
                       DataTextField="Name" 
                       SelectedValue='<%# Bind("SeriesId") %>' />
                  </InsertItemTemplate>
               </asp:TemplateField>

               <asp:TemplateField HeaderText="Kategoria">
                  <InsertItemTemplate>
                     <asp:DropDownList ID="drpCategory" runat="server" 
                       DataSourceID="dsBookCatCategories" DataValueField="Id"
                       DataTextField="Name" 
                       SelectedValue='<%# Bind("CategoryId") %>' />
                  </InsertItemTemplate>
               </asp:TemplateField>                       
            </Fields>
            
            <HeaderStyle CssClass="singleBookTitle" />            
         </asp:DetailsView>     
         <asp:GridView ID="grdErrorsBooks" runat="server" ShowHeader="false"/>            
         </div>
         			
			<div class="entity">
<h2>Wydawcy</h2>
         <asp:GridView ID="grdPub" runat="server" DataSourceID="dsBookCatPublisher" 
               CssClass="entireForm" AllowPaging="false" DataKeyNames="Id" 
               AutoGenerateColumns="false"
               AutoGenerateSelectButton="true"
               AutoGenerateEditButton="true" 
               AutoGenerateDeleteButton="true">

            <Columns>
               <asp:BoundField DataField="Id" HeaderText="Id" ReadOnly="true" SortExpression="True"/>
               <asp:BoundField DataField="Name" HeaderText="Nazwa" SortExpression="Name"/>         
            </Columns>
            
            <HeaderStyle CssClass="singleBookTitle" />            
            <PagerStyle CssClass="singleBookTitle" />
            <PagerSettings Mode="Numeric" />
         </asp:GridView>
         <p></p>			
         <asp:DetailsView ID="dvPub" runat="server" DataSourceID="dsBookCatPublisherOne" 
               CssClass="entireForm" AllowPaging="false" DataKeyNames="Id"
               AutoGenerateRows="false" >
            <Fields>
               <asp:BoundField DataField="Name" HeaderText="Nazwa" />         
            </Fields>            
            <HeaderStyle CssClass="singleBookTitle" /> 
         </asp:DetailsView>
         <p></p>			
         <asp:DetailsView ID="dvPubNew" runat="server" DataSourceID="dsBookCatPublisher" 
               CssClass="entireForm" AllowPaging="false" DataKeyNames="Id"
               AutoGenerateRows="false"
               AutoGenerateInsertButton="true"
               DefaultMode="Insert"
               >

            <Fields>
               <asp:BoundField DataField="Name" HeaderText="Nazwa" />         
            </Fields>
            
            <HeaderStyle CssClass="singleBookTitle" />            
         </asp:DetailsView>  
         <asp:GridView ID="grdErrorsPublishers" runat="server" ShowHeader="false"/>      
         </div>
         
         <div class="entity">
<h2>Series</h2>
         <asp:GridView ID="grdSeries" runat="server" DataSourceID="dsBookCatSeries" 
               CssClass="entireForm" AllowPaging="false" DataKeyNames="Id"
               AutoGenerateColumns="false"
               AutoGenerateSelectButton="true"
               AutoGenerateEditButton="true" 
               AutoGenerateDeleteButton="true">

            <Columns>
               <asp:BoundField DataField="Id" HeaderText="Id" ReadOnly="true"/>
               <asp:BoundField DataField="Name" HeaderText="Nazwa" />         
            </Columns>
            
            <HeaderStyle CssClass="singleBookTitle" />            
            <PagerStyle CssClass="singleBookTitle" />
            <PagerSettings Mode="Numeric" />
         </asp:GridView>
         <p></p>			
         <asp:DetailsView ID="dvSeries" runat="server" DataSourceID="dsBookCatSeriesOne" 
               CssClass="entireForm" AllowPaging="false" DataKeyNames="Id"
               AutoGenerateRows="false" >
            <Fields>
               <asp:BoundField DataField="Name" HeaderText="Nazwa" />         
            </Fields>            
            <HeaderStyle CssClass="singleBookTitle" /> 
         </asp:DetailsView>         
         <p></p>			
         <asp:DetailsView ID="dvSeriesNew" runat="server" DataSourceID="dsBookCatSeries" 
               CssClass="entireForm" AllowPaging="false" DataKeyNames="Id"
               AutoGenerateRows="false"
               AutoGenerateInsertButton="true"
               DefaultMode="Insert"
               >

            <Fields>
               <asp:BoundField DataField="Name" HeaderText="Nazwa" />         
            </Fields>
            
            <HeaderStyle CssClass="singleBookTitle" />            
         </asp:DetailsView>
         <asp:GridView ID="grdErrorsSeries" runat="server" ShowHeader="false"/>
         </div>   
         
         <div class="entity">
<h2>Kategorie</h2>
         <asp:GridView ID="grdCategory" runat="server" DataSourceID="dsBookCatCategories" 
               CssClass="entireForm" AllowPaging="false" DataKeyNames="Id"
               AutoGenerateColumns="false"
               AutoGenerateSelectButton="true"
               AutoGenerateEditButton="true" 
               AutoGenerateDeleteButton="true">

            <Columns>
               <asp:BoundField DataField="Id" HeaderText="Id" ReadOnly="true"/>
               <asp:BoundField DataField="Name" HeaderText="Nazwa" />         
            </Columns>
            
            <HeaderStyle CssClass="singleBookTitle" />            
         </asp:GridView>
         <p></p>			
         <asp:DetailsView ID="dvCategory" runat="server" DataSourceID="dsBookCatCategoriesOne" 
               CssClass="entireForm" AllowPaging="false" DataKeyNames="Id"
               AutoGenerateRows="false" >
            <Fields>
               <asp:BoundField DataField="Name" HeaderText="Nazwa" />         
            </Fields>            
            <HeaderStyle CssClass="singleBookTitle" /> 
         </asp:DetailsView>           
         <p></p>			
         <asp:DetailsView ID="dvCategoryNew" runat="server" DataSourceID="dsBookCatCategories" 
               CssClass="entireForm" AllowPaging="false" DataKeyNames="Id"
               AutoGenerateRows="false"
               AutoGenerateInsertButton="true"
               DefaultMode="Insert"  >

            <Fields>
               <asp:BoundField DataField="Name" HeaderText="Nazwa" />         
            </Fields>
            
            <HeaderStyle CssClass="singleBookTitle" />            
         </asp:DetailsView>
         <asp:GridView ID="grdErrorsCategories" runat="server" ShowHeader="false"/>
         </div>         
         
         <div class="entity">
<h2>Autorzy</h2>
         <asp:GridView ID="grdAuthor" runat="server" DataSourceID="dsBookCatAuthors" 
               CssClass="entireForm" AllowPaging="false" DataKeyNames="Id" 
               AutoGenerateColumns="false"
               AutoGenerateSelectButton="true"
               AutoGenerateEditButton="true" 
               AutoGenerateDeleteButton="true">

            <Columns>
               <asp:BoundField DataField="Id" HeaderText="Id" ReadOnly="true" SortExpression="True"/>
               <asp:BoundField DataField="Name" HeaderText="Nazwa" SortExpression="Name"/>         
            </Columns>
            
            <HeaderStyle CssClass="singleBookTitle" />            
            <PagerStyle CssClass="singleBookTitle" />
            <PagerSettings Mode="Numeric" />
         </asp:GridView>
         <p></p>			
         <asp:DetailsView ID="dvAuthor" runat="server" DataSourceID="dsBookCatAuthorsOne" 
               CssClass="entireForm" AllowPaging="false" DataKeyNames="Id"
               AutoGenerateRows="false" >
            <Fields>
               <asp:BoundField DataField="Name" HeaderText="Nazwa" />         
            </Fields>            
            <HeaderStyle CssClass="singleBookTitle" /> 
         </asp:DetailsView>
         <p></p>			
         <asp:DetailsView ID="dvAuthorNew" runat="server" DataSourceID="dsBookCatAuthors" 
               CssClass="entireForm" AllowPaging="false" DataKeyNames="Id"
               AutoGenerateRows="false"
               AutoGenerateInsertButton="true"
               DefaultMode="Insert"
               >

            <Fields>
               <asp:BoundField DataField="Name" HeaderText="Nazwa" />         
            </Fields>
            
            <HeaderStyle CssClass="singleBookTitle" />            
         </asp:DetailsView>     
         <asp:GridView ID="grdErrorsAuthors" runat="server" ShowHeader="false"/>    
         </div>                   
	</div>
	
	<asp:ObjectDataSource ID="dsBookCatBook" runat="server" EnableCaching="true"
		 TypeName="FourLayer.ApplicationLogic.BookCatalogLogic"  
		 SelectMethod="GetAllBooksAsDataTable" 
		 UpdateMethod="UpdateBook"
		 InsertMethod="InsertBook"
		 DeleteMethod="DeleteBook"
		 DataObjectTypeName="FourLayer.BusinessEntity.Book" OnInserting="dsBookCatBook_Inserting" OnUpdating="dsBookCatBook_Updating"   />
	<asp:ObjectDataSource ID="dsBookCatBookOne" runat="server"
		 TypeName="FourLayer.ApplicationLogic.BookCatalogLogic"  
		 SelectMethod="GetBookByIsbn"  >
      <SelectParameters>
         <asp:ControlParameter ControlID="grdBooks" Name="isbn" Type="string"
           PropertyName="SelectedDataKey.Values[0]" />
      </SelectParameters>   
   </asp:ObjectDataSource> 	
	
	<asp:ObjectDataSource ID="dsBookCatPublisher" runat="server"
		 TypeName="FourLayer.ApplicationLogic.BookCatalogLogic"  
		 SelectMethod="GetAllPublishersAsDataTable" 
		 UpdateMethod="UpdatePublisher"
		 InsertMethod="InsertPublisher"
		 DeleteMethod="DeletePublisher"
		 DataObjectTypeName="FourLayer.BusinessEntity.Publisher" OnInserting="dsBookCatPublisher_Inserting" OnUpdating="dsBookCatPublisher_Updating"   />
	<asp:ObjectDataSource ID="dsBookCatPublisherOne" runat="server"
		 TypeName="FourLayer.ApplicationLogic.BookCatalogLogic"  
		 SelectMethod="GetPublisherById"  >
      <SelectParameters>
         <asp:ControlParameter ControlID="grdPub" Name="id"
           PropertyName="SelectedDataKey.Values[0]" />
      </SelectParameters>   
   </asp:ObjectDataSource>  
	                
	<asp:ObjectDataSource ID="dsBookCatSeries" runat="server"
		 TypeName="FourLayer.ApplicationLogic.BookCatalogLogic"  
		 SelectMethod="GetAllSeries" 
		 UpdateMethod="UpdateSeries"
		 InsertMethod="InsertSeries"
		 DeleteMethod="DeleteSeries"
		 DataObjectTypeName="FourLayer.BusinessEntity.Series" OnInserting="dsBookCatSeries_Inserting" OnUpdating="dsBookCatSeries_Updating"   />
   <asp:ObjectDataSource ID="dsBookCatSeriesOne" runat="server"
		 TypeName="FourLayer.ApplicationLogic.BookCatalogLogic"  
		 SelectMethod="GetSeriesById"  >
      <SelectParameters>
         <asp:ControlParameter ControlID="grdSeries" Name="id"
           PropertyName="SelectedDataKey.Values[0]" />
      </SelectParameters>   
   </asp:ObjectDataSource>  
   
	<asp:ObjectDataSource ID="dsBookCatCategories" runat="server"
		 TypeName="FourLayer.ApplicationLogic.BookCatalogLogic"  
		 SelectMethod="GetAllCategories" 
		 UpdateMethod="UpdateCategory"
		 InsertMethod="InsertCategory"
		 DeleteMethod="DeleteCategory"
		 DataObjectTypeName="FourLayer.BusinessEntity.Category" OnInserting="dsBookCatCategories_Inserting" OnUpdating="dsBookCatCategories_Updating"   />  
   <asp:ObjectDataSource ID="dsBookCatCategoriesOne" runat="server"
		 TypeName="FourLayer.ApplicationLogic.BookCatalogLogic"  
		 SelectMethod="GetCategoryById"  >
      <SelectParameters>
         <asp:ControlParameter ControlID="grdCategory" Name="id"
           PropertyName="SelectedDataKey.Values[0]" />
      </SelectParameters>   
   </asp:ObjectDataSource> 		 
   
	<asp:ObjectDataSource ID="dsBookCatAuthors" runat="server"
		 TypeName="FourLayer.ApplicationLogic.BookCatalogLogic"  
		 SelectMethod="GetAllAuthors" 
		 UpdateMethod="UpdateAuthor"
		 InsertMethod="InsertAuthor"
		 DeleteMethod="DeleteAuthor"
		 DataObjectTypeName="FourLayer.BusinessEntity.Author" OnInserting="dsBookCatAuthors_Inserting" OnUpdating="dsBookCatAuthors_Updating"   />  
   <asp:ObjectDataSource ID="dsBookCatAuthorsOne" runat="server"
		 TypeName="FourLayer.ApplicationLogic.BookCatalogLogic"  
		 SelectMethod="GetAuthorById"  >
      <SelectParameters>
         <asp:ControlParameter ControlID="grdAuthor" Name="id"
           PropertyName="SelectedDataKey.Values[0]" />
      </SelectParameters>   
   </asp:ObjectDataSource>     
   
	</form>
</body>
</html>


