using System;
using System.Data;

namespace FourLayer.BusinessEntity
{
   /// <summary>
   /// Hermetyzuje dane dla pojedynczego wydawcy
   /// </summary>
   [Serializable]
   public class Publisher: AbstractEntity 
   {

      // dane skadowe
      private string _name;

      public Publisher() { }
      public Publisher(int id, string name)
         : base(id)
      {
         _name = name;
      }
      
      public int Id
      {
         get { return (int)Key; }
         set { Key = value; }
      }
      public string Name
      {
         get { return _name; }
         set { _name = value; }
      }

      public override string ToString()
      {
         return Key + "," + Name;
      }

      /// <summary>
      /// Sprawdza, czy stan obiektu jest prawidowy
      /// </summary>
      protected override bool CheckIfSubClassStateIsValid
      {
         get
         {
            if (Name == null)
            {
               AddBrokenRule("Wydawca: Nazwa musi mie nadan warot");
               return false;
            }

            if (Name.Length > 0)
               return true;
            else
            {
               AddBrokenRule("Wydawca: Nazwa jest pusta");
               return false;
            }
         }
      }
   }
}
