using System;
using System.Data;
using System.Data.Common;

namespace TwoLayer.DataAccess
{
   /// <summary>
   /// 
   /// </summary>
   public class CategoryDA : AbstractDA
   {

      protected override string SelectStatement
      {
         get { return "SELECT CategoryId, CategoryName FROM Categories"; }
      }

      /// <summary>
      /// Zwraca tabel z danymi zawierajc informacje o tabeli wydawcy dla okrelonego identyfikatora.
      /// Ten zbir danych bdzie zawiera 0 lub 1 wiersz danych.
      /// </summary>
      public override DataTable GetById(object oId)
      {
         int id = (int)oId;

         // utwrz sparametryzowan instrukcj zapytania
         string sql = SelectStatement + " WHERE CategoryId=@id";

         // utwrz tablic parametrw
         DbParameter[] parameters = new DbParameter[] {
			MakeParameter("@id", id, DbType.Int32)
															};
         // zwr wynik
         return GetDataTable(sql, parameters);
      }

   }
}

