using System;
using System.Data;
using System.Collections.Generic;

namespace ThreeLayer.Business
{
   /// <summary>
   /// Reprezentuje klas bazow wszystkich obiektw biznesowych
   /// </summary>
   public abstract class AbstractBO
   {
      // dane skadowe
      protected const int DEFAULT_ID = 0;

      // flagi okrelajce, czy obiekt jest nowy lub by modyfikowany
      private bool _isNew = true;
      private bool _isModified = false;
      // zbir opisw wszystkich naruszonych regu
      private List<string> _brokenRules = new List<string>();


      /// <summary>
      /// Kada podklasa bedzie odpowiaqda za sprawdzanie, czy 
      /// jej stan (dane skadowe) narusza reguy biznesowe
      /// </summary>
      protected abstract bool CheckIfSubClassStateIsValid
      {
         get;
      }

      /// <summary>
      /// Podklasy musz mie moliwo dodawania opisu naruszonej reguy
      /// </summary>
      protected void AddBrokenRule(string rule)
      {
         _brokenRules.Add(rule);
      }
      /// <summary>
      /// Zwraca opisy naruszonych regu
      /// </summary>
      public List<string> BrokenRules
      {
         get { return _brokenRules; }
      }
      /// <summary>
      /// Czy obiekt biznesowy jest prawidowy
      /// </summary>
      public bool IsValid
      {
         get
         {
            _brokenRules.Clear();
            return CheckIfSubClassStateIsValid;
         }
      }
      /// <summary>
      /// Czy obiekt by modyfikowany od chwili ostatniego zachowania
      /// </summary>
      protected bool IsModified
      {
         get { return _isModified; }
         set { _isModified = value; }
      }
      /// <summary>
      /// Czy obiekt biznesowy jest nowy albo czy zawiera
      /// dane istniejce w bazie danych
      /// </summary>
      protected bool IsNew
      {
         get { return _isNew; }
         set { _isNew = value; }
      }
      
   }
}
